package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  OwnerAccount,
  EncryptionMode,
  ProviderName,
  LagName,
  Count,
  BooleanFlag,
  AwsDeviceV2,
  MacSecCapable,
  Bandwidth,
  Region,
  AwsLogicalDeviceId,
  AwsDevice,
  JumboFrameCapable,
  LagId,
  LocationCode
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class UpdateLagResponse(
    connectionsBandwidth: Optional[Bandwidth] = Optional.Absent,
    numberOfConnections: Optional[Count] = Optional.Absent,
    lagId: Optional[LagId] = Optional.Absent,
    ownerAccount: Optional[OwnerAccount] = Optional.Absent,
    lagName: Optional[LagName] = Optional.Absent,
    lagState: Optional[zio.aws.directconnect.model.LagState] = Optional.Absent,
    location: Optional[LocationCode] = Optional.Absent,
    region: Optional[Region] = Optional.Absent,
    minimumLinks: Optional[Count] = Optional.Absent,
    awsDevice: Optional[AwsDevice] = Optional.Absent,
    awsDeviceV2: Optional[AwsDeviceV2] = Optional.Absent,
    awsLogicalDeviceId: Optional[AwsLogicalDeviceId] = Optional.Absent,
    connections: Optional[Iterable[zio.aws.directconnect.model.Connection]] =
      Optional.Absent,
    allowsHostedConnections: Optional[BooleanFlag] = Optional.Absent,
    jumboFrameCapable: Optional[JumboFrameCapable] = Optional.Absent,
    hasLogicalRedundancy: Optional[
      zio.aws.directconnect.model.HasLogicalRedundancy
    ] = Optional.Absent,
    tags: Optional[Iterable[zio.aws.directconnect.model.Tag]] = Optional.Absent,
    providerName: Optional[ProviderName] = Optional.Absent,
    macSecCapable: Optional[MacSecCapable] = Optional.Absent,
    encryptionMode: Optional[EncryptionMode] = Optional.Absent,
    macSecKeys: Optional[Iterable[zio.aws.directconnect.model.MacSecKey]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.UpdateLagResponse = {
    import UpdateLagResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.UpdateLagResponse
      .builder()
      .optionallyWith(
        connectionsBandwidth.map(value =>
          Bandwidth.unwrap(value): java.lang.String
        )
      )(_.connectionsBandwidth)
      .optionallyWith(
        numberOfConnections.map(value => Count.unwrap(value): Integer)
      )(_.numberOfConnections)
      .optionallyWith(
        lagId.map(value => LagId.unwrap(value): java.lang.String)
      )(_.lagId)
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        lagName.map(value => LagName.unwrap(value): java.lang.String)
      )(_.lagName)
      .optionallyWith(lagState.map(value => value.unwrap))(_.lagState)
      .optionallyWith(
        location.map(value => LocationCode.unwrap(value): java.lang.String)
      )(_.location)
      .optionallyWith(
        region.map(value => Region.unwrap(value): java.lang.String)
      )(_.region)
      .optionallyWith(minimumLinks.map(value => Count.unwrap(value): Integer))(
        _.minimumLinks
      )
      .optionallyWith(
        awsDevice.map(value => AwsDevice.unwrap(value): java.lang.String)
      )(_.awsDevice)
      .optionallyWith(
        awsDeviceV2.map(value => AwsDeviceV2.unwrap(value): java.lang.String)
      )(_.awsDeviceV2)
      .optionallyWith(
        awsLogicalDeviceId.map(value =>
          AwsLogicalDeviceId.unwrap(value): java.lang.String
        )
      )(_.awsLogicalDeviceId)
      .optionallyWith(
        connections.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.connections)
      .optionallyWith(
        allowsHostedConnections.map(value =>
          BooleanFlag.unwrap(value): java.lang.Boolean
        )
      )(_.allowsHostedConnections)
      .optionallyWith(
        jumboFrameCapable.map(value =>
          JumboFrameCapable.unwrap(value): java.lang.Boolean
        )
      )(_.jumboFrameCapable)
      .optionallyWith(hasLogicalRedundancy.map(value => value.unwrap))(
        _.hasLogicalRedundancy
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        providerName.map(value => ProviderName.unwrap(value): java.lang.String)
      )(_.providerName)
      .optionallyWith(
        macSecCapable.map(value =>
          MacSecCapable.unwrap(value): java.lang.Boolean
        )
      )(_.macSecCapable)
      .optionallyWith(
        encryptionMode.map(value =>
          EncryptionMode.unwrap(value): java.lang.String
        )
      )(_.encryptionMode)
      .optionallyWith(
        macSecKeys.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.macSecKeys)
      .build()
  }
  def asReadOnly: zio.aws.directconnect.model.UpdateLagResponse.ReadOnly =
    zio.aws.directconnect.model.UpdateLagResponse.wrap(buildAwsValue())
}
object UpdateLagResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.UpdateLagResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.UpdateLagResponse =
      zio.aws.directconnect.model.UpdateLagResponse(
        connectionsBandwidth.map(value => value),
        numberOfConnections.map(value => value),
        lagId.map(value => value),
        ownerAccount.map(value => value),
        lagName.map(value => value),
        lagState.map(value => value),
        location.map(value => value),
        region.map(value => value),
        minimumLinks.map(value => value),
        awsDevice.map(value => value),
        awsDeviceV2.map(value => value),
        awsLogicalDeviceId.map(value => value),
        connections.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        allowsHostedConnections.map(value => value),
        jumboFrameCapable.map(value => value),
        hasLogicalRedundancy.map(value => value),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        providerName.map(value => value),
        macSecCapable.map(value => value),
        encryptionMode.map(value => value),
        macSecKeys.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def connectionsBandwidth: Optional[Bandwidth]
    def numberOfConnections: Optional[Count]
    def lagId: Optional[LagId]
    def ownerAccount: Optional[OwnerAccount]
    def lagName: Optional[LagName]
    def lagState: Optional[zio.aws.directconnect.model.LagState]
    def location: Optional[LocationCode]
    def region: Optional[Region]
    def minimumLinks: Optional[Count]
    def awsDevice: Optional[AwsDevice]
    def awsDeviceV2: Optional[AwsDeviceV2]
    def awsLogicalDeviceId: Optional[AwsLogicalDeviceId]
    def connections
        : Optional[List[zio.aws.directconnect.model.Connection.ReadOnly]]
    def allowsHostedConnections: Optional[BooleanFlag]
    def jumboFrameCapable: Optional[JumboFrameCapable]
    def hasLogicalRedundancy
        : Optional[zio.aws.directconnect.model.HasLogicalRedundancy]
    def tags: Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]]
    def providerName: Optional[ProviderName]
    def macSecCapable: Optional[MacSecCapable]
    def encryptionMode: Optional[EncryptionMode]
    def macSecKeys
        : Optional[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]]
    def getConnectionsBandwidth: ZIO[Any, AwsError, Bandwidth] =
      AwsError.unwrapOptionField("connectionsBandwidth", connectionsBandwidth)
    def getNumberOfConnections: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("numberOfConnections", numberOfConnections)
    def getLagId: ZIO[Any, AwsError, LagId] =
      AwsError.unwrapOptionField("lagId", lagId)
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getLagName: ZIO[Any, AwsError, LagName] =
      AwsError.unwrapOptionField("lagName", lagName)
    def getLagState: ZIO[Any, AwsError, zio.aws.directconnect.model.LagState] =
      AwsError.unwrapOptionField("lagState", lagState)
    def getLocation: ZIO[Any, AwsError, LocationCode] =
      AwsError.unwrapOptionField("location", location)
    def getRegion: ZIO[Any, AwsError, Region] =
      AwsError.unwrapOptionField("region", region)
    def getMinimumLinks: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("minimumLinks", minimumLinks)
    def getAwsDevice: ZIO[Any, AwsError, AwsDevice] =
      AwsError.unwrapOptionField("awsDevice", awsDevice)
    def getAwsDeviceV2: ZIO[Any, AwsError, AwsDeviceV2] =
      AwsError.unwrapOptionField("awsDeviceV2", awsDeviceV2)
    def getAwsLogicalDeviceId: ZIO[Any, AwsError, AwsLogicalDeviceId] =
      AwsError.unwrapOptionField("awsLogicalDeviceId", awsLogicalDeviceId)
    def getConnections: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.Connection.ReadOnly
    ]] = AwsError.unwrapOptionField("connections", connections)
    def getAllowsHostedConnections: ZIO[Any, AwsError, BooleanFlag] = AwsError
      .unwrapOptionField("allowsHostedConnections", allowsHostedConnections)
    def getJumboFrameCapable: ZIO[Any, AwsError, JumboFrameCapable] =
      AwsError.unwrapOptionField("jumboFrameCapable", jumboFrameCapable)
    def getHasLogicalRedundancy
        : ZIO[Any, AwsError, zio.aws.directconnect.model.HasLogicalRedundancy] =
      AwsError.unwrapOptionField("hasLogicalRedundancy", hasLogicalRedundancy)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getProviderName: ZIO[Any, AwsError, ProviderName] =
      AwsError.unwrapOptionField("providerName", providerName)
    def getMacSecCapable: ZIO[Any, AwsError, MacSecCapable] =
      AwsError.unwrapOptionField("macSecCapable", macSecCapable)
    def getEncryptionMode: ZIO[Any, AwsError, EncryptionMode] =
      AwsError.unwrapOptionField("encryptionMode", encryptionMode)
    def getMacSecKeys: ZIO[Any, AwsError, List[
      zio.aws.directconnect.model.MacSecKey.ReadOnly
    ]] = AwsError.unwrapOptionField("macSecKeys", macSecKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateLagResponse
  ) extends zio.aws.directconnect.model.UpdateLagResponse.ReadOnly {
    override val connectionsBandwidth: Optional[Bandwidth] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connectionsBandwidth())
        .map(value => zio.aws.directconnect.model.primitives.Bandwidth(value))
    override val numberOfConnections: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.numberOfConnections())
      .map(value => zio.aws.directconnect.model.primitives.Count(value))
    override val lagId: Optional[LagId] = zio.aws.core.internal
      .optionalFromNullable(impl.lagId())
      .map(value => zio.aws.directconnect.model.primitives.LagId(value))
    override val ownerAccount: Optional[OwnerAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val lagName: Optional[LagName] = zio.aws.core.internal
      .optionalFromNullable(impl.lagName())
      .map(value => zio.aws.directconnect.model.primitives.LagName(value))
    override val lagState: Optional[zio.aws.directconnect.model.LagState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lagState())
        .map(value => zio.aws.directconnect.model.LagState.wrap(value))
    override val location: Optional[LocationCode] = zio.aws.core.internal
      .optionalFromNullable(impl.location())
      .map(value => zio.aws.directconnect.model.primitives.LocationCode(value))
    override val region: Optional[Region] = zio.aws.core.internal
      .optionalFromNullable(impl.region())
      .map(value => zio.aws.directconnect.model.primitives.Region(value))
    override val minimumLinks: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.minimumLinks())
      .map(value => zio.aws.directconnect.model.primitives.Count(value))
    override val awsDevice: Optional[AwsDevice] = zio.aws.core.internal
      .optionalFromNullable(impl.awsDevice())
      .map(value => zio.aws.directconnect.model.primitives.AwsDevice(value))
    override val awsDeviceV2: Optional[AwsDeviceV2] = zio.aws.core.internal
      .optionalFromNullable(impl.awsDeviceV2())
      .map(value => zio.aws.directconnect.model.primitives.AwsDeviceV2(value))
    override val awsLogicalDeviceId: Optional[AwsLogicalDeviceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.awsLogicalDeviceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.AwsLogicalDeviceId(value)
        )
    override val connections
        : Optional[List[zio.aws.directconnect.model.Connection.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.connections())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Connection.wrap(item)
          }.toList
        )
    override val allowsHostedConnections: Optional[BooleanFlag] =
      zio.aws.core.internal
        .optionalFromNullable(impl.allowsHostedConnections())
        .map(value => zio.aws.directconnect.model.primitives.BooleanFlag(value))
    override val jumboFrameCapable: Optional[JumboFrameCapable] =
      zio.aws.core.internal
        .optionalFromNullable(impl.jumboFrameCapable())
        .map(value =>
          zio.aws.directconnect.model.primitives.JumboFrameCapable(value)
        )
    override val hasLogicalRedundancy
        : Optional[zio.aws.directconnect.model.HasLogicalRedundancy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.hasLogicalRedundancy())
        .map(value =>
          zio.aws.directconnect.model.HasLogicalRedundancy.wrap(value)
        )
    override val tags
        : Optional[List[zio.aws.directconnect.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.Tag.wrap(item)
          }.toList
        )
    override val providerName: Optional[ProviderName] = zio.aws.core.internal
      .optionalFromNullable(impl.providerName())
      .map(value => zio.aws.directconnect.model.primitives.ProviderName(value))
    override val macSecCapable: Optional[MacSecCapable] = zio.aws.core.internal
      .optionalFromNullable(impl.macSecCapable())
      .map(value => zio.aws.directconnect.model.primitives.MacSecCapable(value))
    override val encryptionMode: Optional[EncryptionMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.encryptionMode())
        .map(value =>
          zio.aws.directconnect.model.primitives.EncryptionMode(value)
        )
    override val macSecKeys
        : Optional[List[zio.aws.directconnect.model.MacSecKey.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.macSecKeys())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.directconnect.model.MacSecKey.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.UpdateLagResponse
  ): zio.aws.directconnect.model.UpdateLagResponse.ReadOnly = new Wrapper(impl)
}
