package zio.aws.directconnect.model
import zio.aws.directconnect.model.primitives.{
  OwnerAccount,
  FailureTestHistoryStatus,
  TestDuration,
  EndTime,
  StartTime,
  VirtualInterfaceId,
  TestId,
  BGPPeerId
}
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class VirtualInterfaceTestHistory(
    testId: Optional[TestId] = Optional.Absent,
    virtualInterfaceId: Optional[VirtualInterfaceId] = Optional.Absent,
    bgpPeers: Optional[Iterable[BGPPeerId]] = Optional.Absent,
    status: Optional[FailureTestHistoryStatus] = Optional.Absent,
    ownerAccount: Optional[OwnerAccount] = Optional.Absent,
    testDurationInMinutes: Optional[TestDuration] = Optional.Absent,
    startTime: Optional[StartTime] = Optional.Absent,
    endTime: Optional[EndTime] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory = {
    import VirtualInterfaceTestHistory.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory
      .builder()
      .optionallyWith(
        testId.map(value => TestId.unwrap(value): java.lang.String)
      )(_.testId)
      .optionallyWith(
        virtualInterfaceId.map(value =>
          VirtualInterfaceId.unwrap(value): java.lang.String
        )
      )(_.virtualInterfaceId)
      .optionallyWith(
        bgpPeers.map(value =>
          value.map { item =>
            BGPPeerId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.bgpPeers)
      .optionallyWith(
        status.map(value =>
          FailureTestHistoryStatus.unwrap(value): java.lang.String
        )
      )(_.status)
      .optionallyWith(
        ownerAccount.map(value => OwnerAccount.unwrap(value): java.lang.String)
      )(_.ownerAccount)
      .optionallyWith(
        testDurationInMinutes.map(value => TestDuration.unwrap(value): Integer)
      )(_.testDurationInMinutes)
      .optionallyWith(startTime.map(value => StartTime.unwrap(value): Instant))(
        _.startTime
      )
      .optionallyWith(endTime.map(value => EndTime.unwrap(value): Instant))(
        _.endTime
      )
      .build()
  }
  def asReadOnly
      : zio.aws.directconnect.model.VirtualInterfaceTestHistory.ReadOnly =
    zio.aws.directconnect.model.VirtualInterfaceTestHistory
      .wrap(buildAwsValue())
}
object VirtualInterfaceTestHistory {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.directconnect.model.VirtualInterfaceTestHistory =
      zio.aws.directconnect.model.VirtualInterfaceTestHistory(
        testId.map(value => value),
        virtualInterfaceId.map(value => value),
        bgpPeers.map(value => value),
        status.map(value => value),
        ownerAccount.map(value => value),
        testDurationInMinutes.map(value => value),
        startTime.map(value => value),
        endTime.map(value => value)
      )
    def testId: Optional[TestId]
    def virtualInterfaceId: Optional[VirtualInterfaceId]
    def bgpPeers: Optional[List[BGPPeerId]]
    def status: Optional[FailureTestHistoryStatus]
    def ownerAccount: Optional[OwnerAccount]
    def testDurationInMinutes: Optional[TestDuration]
    def startTime: Optional[StartTime]
    def endTime: Optional[EndTime]
    def getTestId: ZIO[Any, AwsError, TestId] =
      AwsError.unwrapOptionField("testId", testId)
    def getVirtualInterfaceId: ZIO[Any, AwsError, VirtualInterfaceId] =
      AwsError.unwrapOptionField("virtualInterfaceId", virtualInterfaceId)
    def getBgpPeers: ZIO[Any, AwsError, List[BGPPeerId]] =
      AwsError.unwrapOptionField("bgpPeers", bgpPeers)
    def getStatus: ZIO[Any, AwsError, FailureTestHistoryStatus] =
      AwsError.unwrapOptionField("status", status)
    def getOwnerAccount: ZIO[Any, AwsError, OwnerAccount] =
      AwsError.unwrapOptionField("ownerAccount", ownerAccount)
    def getTestDurationInMinutes: ZIO[Any, AwsError, TestDuration] =
      AwsError.unwrapOptionField("testDurationInMinutes", testDurationInMinutes)
    def getStartTime: ZIO[Any, AwsError, StartTime] =
      AwsError.unwrapOptionField("startTime", startTime)
    def getEndTime: ZIO[Any, AwsError, EndTime] =
      AwsError.unwrapOptionField("endTime", endTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory
  ) extends zio.aws.directconnect.model.VirtualInterfaceTestHistory.ReadOnly {
    override val testId: Optional[TestId] = zio.aws.core.internal
      .optionalFromNullable(impl.testId())
      .map(value => zio.aws.directconnect.model.primitives.TestId(value))
    override val virtualInterfaceId: Optional[VirtualInterfaceId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.virtualInterfaceId())
        .map(value =>
          zio.aws.directconnect.model.primitives.VirtualInterfaceId(value)
        )
    override val bgpPeers: Optional[List[BGPPeerId]] = zio.aws.core.internal
      .optionalFromNullable(impl.bgpPeers())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.directconnect.model.primitives.BGPPeerId(item)
        }.toList
      )
    override val status: Optional[FailureTestHistoryStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value =>
          zio.aws.directconnect.model.primitives.FailureTestHistoryStatus(value)
        )
    override val ownerAccount: Optional[OwnerAccount] = zio.aws.core.internal
      .optionalFromNullable(impl.ownerAccount())
      .map(value => zio.aws.directconnect.model.primitives.OwnerAccount(value))
    override val testDurationInMinutes: Optional[TestDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testDurationInMinutes())
        .map(value =>
          zio.aws.directconnect.model.primitives.TestDuration(value)
        )
    override val startTime: Optional[StartTime] = zio.aws.core.internal
      .optionalFromNullable(impl.startTime())
      .map(value => zio.aws.directconnect.model.primitives.StartTime(value))
    override val endTime: Optional[EndTime] = zio.aws.core.internal
      .optionalFromNullable(impl.endTime())
      .map(value => zio.aws.directconnect.model.primitives.EndTime(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.directconnect.model.VirtualInterfaceTestHistory
  ): zio.aws.directconnect.model.VirtualInterfaceTestHistory.ReadOnly =
    new Wrapper(impl)
}
