package zio.aws.directconnect
import zio.aws.directconnect.model.primitives.LoaContent.Type
import zio.aws.directconnect.model.primitives.{
  ProviderName,
  PortSpeed,
  ResourceArn,
  TagKey,
  BGPPeerId
}
import java.time.Instant
import zio.Chunk
import zio.prelude.Subtype
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ASN extends Subtype[Int]
    type ASN = zio.aws.directconnect.model.primitives.ASN.Type
    object AgreementName extends Subtype[String]
    type AgreementName =
      zio.aws.directconnect.model.primitives.AgreementName.Type
    object AmazonAddress extends Subtype[String]
    type AmazonAddress =
      zio.aws.directconnect.model.primitives.AmazonAddress.Type
    object AssociatedGatewayId extends Subtype[String]
    type AssociatedGatewayId =
      zio.aws.directconnect.model.primitives.AssociatedGatewayId.Type
    object AwsDevice extends Subtype[String]
    type AwsDevice = zio.aws.directconnect.model.primitives.AwsDevice.Type
    object AwsDeviceV2 extends Subtype[String]
    type AwsDeviceV2 = zio.aws.directconnect.model.primitives.AwsDeviceV2.Type
    object AwsLogicalDeviceId extends Subtype[String]
    type AwsLogicalDeviceId =
      zio.aws.directconnect.model.primitives.AwsLogicalDeviceId.Type
    object BGPAuthKey extends Subtype[String]
    type BGPAuthKey = zio.aws.directconnect.model.primitives.BGPAuthKey.Type
    object BGPPeerId extends Subtype[String]
    type BGPPeerId = zio.aws.directconnect.model.primitives.BGPPeerId.Type
    object Bandwidth extends Subtype[String]
    type Bandwidth = zio.aws.directconnect.model.primitives.Bandwidth.Type
    object BooleanFlag extends Subtype[Boolean]
    type BooleanFlag = zio.aws.directconnect.model.primitives.BooleanFlag.Type
    object CIDR extends Subtype[String]
    type CIDR = zio.aws.directconnect.model.primitives.CIDR.Type
    object Cak extends Subtype[String]
    type Cak = zio.aws.directconnect.model.primitives.Cak.Type
    object Ckn extends Subtype[String]
    type Ckn = zio.aws.directconnect.model.primitives.Ckn.Type
    object ConnectionId extends Subtype[String]
    type ConnectionId = zio.aws.directconnect.model.primitives.ConnectionId.Type
    object ConnectionName extends Subtype[String]
    type ConnectionName =
      zio.aws.directconnect.model.primitives.ConnectionName.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.directconnect.model.primitives.Count.Type
    object CustomerAddress extends Subtype[String]
    type CustomerAddress =
      zio.aws.directconnect.model.primitives.CustomerAddress.Type
    object DirectConnectGatewayAssociationId extends Subtype[String]
    type DirectConnectGatewayAssociationId =
      zio.aws.directconnect.model.primitives.DirectConnectGatewayAssociationId.Type
    object DirectConnectGatewayAssociationProposalId extends Subtype[String]
    type DirectConnectGatewayAssociationProposalId =
      zio.aws.directconnect.model.primitives.DirectConnectGatewayAssociationProposalId.Type
    object DirectConnectGatewayId extends Subtype[String]
    type DirectConnectGatewayId =
      zio.aws.directconnect.model.primitives.DirectConnectGatewayId.Type
    object DirectConnectGatewayName extends Subtype[String]
    type DirectConnectGatewayName =
      zio.aws.directconnect.model.primitives.DirectConnectGatewayName.Type
    object EnableSiteLink extends Subtype[Boolean]
    type EnableSiteLink =
      zio.aws.directconnect.model.primitives.EnableSiteLink.Type
    object EncryptionMode extends Subtype[String]
    type EncryptionMode =
      zio.aws.directconnect.model.primitives.EncryptionMode.Type
    object EndTime extends Subtype[Instant]
    type EndTime = zio.aws.directconnect.model.primitives.EndTime.Type
    object FailureTestHistoryStatus extends Subtype[String]
    type FailureTestHistoryStatus =
      zio.aws.directconnect.model.primitives.FailureTestHistoryStatus.Type
    object GatewayIdToAssociate extends Subtype[String]
    type GatewayIdToAssociate =
      zio.aws.directconnect.model.primitives.GatewayIdToAssociate.Type
    object GatewayIdentifier extends Subtype[String]
    type GatewayIdentifier =
      zio.aws.directconnect.model.primitives.GatewayIdentifier.Type
    object InterconnectId extends Subtype[String]
    type InterconnectId =
      zio.aws.directconnect.model.primitives.InterconnectId.Type
    object InterconnectName extends Subtype[String]
    type InterconnectName =
      zio.aws.directconnect.model.primitives.InterconnectName.Type
    object JumboFrameCapable extends Subtype[Boolean]
    type JumboFrameCapable =
      zio.aws.directconnect.model.primitives.JumboFrameCapable.Type
    object LagId extends Subtype[String]
    type LagId = zio.aws.directconnect.model.primitives.LagId.Type
    object LagName extends Subtype[String]
    type LagName = zio.aws.directconnect.model.primitives.LagName.Type
    object LoaContent extends Subtype[Chunk[Byte]]
    type LoaContent = zio.aws.directconnect.model.primitives.LoaContent.Type
    object LoaIssueTime extends Subtype[Instant]
    type LoaIssueTime = zio.aws.directconnect.model.primitives.LoaIssueTime.Type
    object LocationCode extends Subtype[String]
    type LocationCode = zio.aws.directconnect.model.primitives.LocationCode.Type
    object LocationName extends Subtype[String]
    type LocationName = zio.aws.directconnect.model.primitives.LocationName.Type
    object LongAsn extends Subtype[Long]
    type LongAsn = zio.aws.directconnect.model.primitives.LongAsn.Type
    object MTU extends Subtype[Int]
    type MTU = zio.aws.directconnect.model.primitives.MTU.Type
    object MacSecCapable extends Subtype[Boolean]
    type MacSecCapable =
      zio.aws.directconnect.model.primitives.MacSecCapable.Type
    object MaxResultSetSize extends Subtype[Int]
    type MaxResultSetSize =
      zio.aws.directconnect.model.primitives.MaxResultSetSize.Type
    object OwnerAccount extends Subtype[String]
    type OwnerAccount = zio.aws.directconnect.model.primitives.OwnerAccount.Type
    object PaginationToken extends Subtype[String]
    type PaginationToken =
      zio.aws.directconnect.model.primitives.PaginationToken.Type
    object PartnerName extends Subtype[String]
    type PartnerName = zio.aws.directconnect.model.primitives.PartnerName.Type
    object Platform extends Subtype[String]
    type Platform = zio.aws.directconnect.model.primitives.Platform.Type
    object PortEncryptionStatus extends Subtype[String]
    type PortEncryptionStatus =
      zio.aws.directconnect.model.primitives.PortEncryptionStatus.Type
    object PortSpeed extends Subtype[String]
    type PortSpeed = zio.aws.directconnect.model.primitives.PortSpeed.Type
    object ProviderName extends Subtype[String]
    type ProviderName = zio.aws.directconnect.model.primitives.ProviderName.Type
    object Region extends Subtype[String]
    type Region = zio.aws.directconnect.model.primitives.Region.Type
    object RequestMACSec extends Subtype[Boolean]
    type RequestMACSec =
      zio.aws.directconnect.model.primitives.RequestMACSec.Type
    object ResourceArn extends Subtype[String]
    type ResourceArn = zio.aws.directconnect.model.primitives.ResourceArn.Type
    object RouterConfig extends Subtype[String]
    type RouterConfig = zio.aws.directconnect.model.primitives.RouterConfig.Type
    object RouterTypeIdentifier extends Subtype[String]
    type RouterTypeIdentifier =
      zio.aws.directconnect.model.primitives.RouterTypeIdentifier.Type
    object SecretARN extends Subtype[String]
    type SecretARN = zio.aws.directconnect.model.primitives.SecretARN.Type
    object SiteLinkEnabled extends Subtype[Boolean]
    type SiteLinkEnabled =
      zio.aws.directconnect.model.primitives.SiteLinkEnabled.Type
    object Software extends Subtype[String]
    type Software = zio.aws.directconnect.model.primitives.Software.Type
    object StartOnDate extends Subtype[String]
    type StartOnDate = zio.aws.directconnect.model.primitives.StartOnDate.Type
    object StartTime extends Subtype[Instant]
    type StartTime = zio.aws.directconnect.model.primitives.StartTime.Type
    object State extends Subtype[String]
    type State = zio.aws.directconnect.model.primitives.State.Type
    object StateChangeError extends Subtype[String]
    type StateChangeError =
      zio.aws.directconnect.model.primitives.StateChangeError.Type
    object Status extends Subtype[String]
    type Status = zio.aws.directconnect.model.primitives.Status.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.directconnect.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.directconnect.model.primitives.TagValue.Type
    object TestDuration extends Subtype[Int]
    type TestDuration = zio.aws.directconnect.model.primitives.TestDuration.Type
    object TestId extends Subtype[String]
    type TestId = zio.aws.directconnect.model.primitives.TestId.Type
    object VLAN extends Subtype[Int]
    type VLAN = zio.aws.directconnect.model.primitives.VLAN.Type
    object Vendor extends Subtype[String]
    type Vendor = zio.aws.directconnect.model.primitives.Vendor.Type
    object VirtualGatewayId extends Subtype[String]
    type VirtualGatewayId =
      zio.aws.directconnect.model.primitives.VirtualGatewayId.Type
    object VirtualGatewayRegion extends Subtype[String]
    type VirtualGatewayRegion =
      zio.aws.directconnect.model.primitives.VirtualGatewayRegion.Type
    object VirtualGatewayState extends Subtype[String]
    type VirtualGatewayState =
      zio.aws.directconnect.model.primitives.VirtualGatewayState.Type
    object VirtualInterfaceId extends Subtype[String]
    type VirtualInterfaceId =
      zio.aws.directconnect.model.primitives.VirtualInterfaceId.Type
    object VirtualInterfaceName extends Subtype[String]
    type VirtualInterfaceName =
      zio.aws.directconnect.model.primitives.VirtualInterfaceName.Type
    object VirtualInterfaceRegion extends Subtype[String]
    type VirtualInterfaceRegion =
      zio.aws.directconnect.model.primitives.VirtualInterfaceRegion.Type
    object VirtualInterfaceType extends Subtype[String]
    type VirtualInterfaceType =
      zio.aws.directconnect.model.primitives.VirtualInterfaceType.Type
    object XsltTemplateName extends Subtype[String]
    type XsltTemplateName =
      zio.aws.directconnect.model.primitives.XsltTemplateName.Type
    object XsltTemplateNameForMacSec extends Subtype[String]
    type XsltTemplateNameForMacSec =
      zio.aws.directconnect.model.primitives.XsltTemplateNameForMacSec.Type
  }
  type AgreementList = List[zio.aws.directconnect.model.CustomerAgreement]
  type AvailableMacSecPortSpeeds = List[PortSpeed]
  type AvailablePortSpeeds = List[PortSpeed]
  type BGPPeerIdList = List[BGPPeerId]
  type BGPPeerList = List[zio.aws.directconnect.model.BGPPeer]
  type ConnectionList = List[zio.aws.directconnect.model.Connection]
  type DirectConnectGatewayAssociationList =
    List[zio.aws.directconnect.model.DirectConnectGatewayAssociation]
  type DirectConnectGatewayAssociationProposalList =
    List[zio.aws.directconnect.model.DirectConnectGatewayAssociationProposal]
  type DirectConnectGatewayAttachmentList =
    List[zio.aws.directconnect.model.DirectConnectGatewayAttachment]
  type DirectConnectGatewayList =
    List[zio.aws.directconnect.model.DirectConnectGateway]
  type InterconnectList = List[zio.aws.directconnect.model.Interconnect]
  type LagList = List[zio.aws.directconnect.model.Lag]
  type LocationList = List[zio.aws.directconnect.model.Location]
  type MacSecKeyList = List[zio.aws.directconnect.model.MacSecKey]
  type ProviderList = List[ProviderName]
  type ResourceArnList = List[ResourceArn]
  type ResourceTagList = List[zio.aws.directconnect.model.ResourceTag]
  type RouteFilterPrefixList =
    List[zio.aws.directconnect.model.RouteFilterPrefix]
  type TagKeyList = List[TagKey]
  type TagList = List[zio.aws.directconnect.model.Tag]
  type VirtualGatewayList = List[zio.aws.directconnect.model.VirtualGateway]
  type VirtualInterfaceList = List[zio.aws.directconnect.model.VirtualInterface]
  type VirtualInterfaceTestHistoryList =
    List[zio.aws.directconnect.model.VirtualInterfaceTestHistory]
}
