package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.ActionName
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Action(
    name: ActionName,
    crossRegionCopy: Iterable[zio.aws.dlm.model.CrossRegionCopyAction]
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.Action = {
    import Action.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.Action
      .builder()
      .name(ActionName.unwrap(name): java.lang.String)
      .crossRegionCopy(crossRegionCopy.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.Action.ReadOnly =
    zio.aws.dlm.model.Action.wrap(buildAwsValue())
}
object Action {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.Action] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.Action = zio.aws.dlm.model.Action(
      name,
      crossRegionCopy.map { item =>
        item.asEditable
      }
    )
    def name: ActionName
    def crossRegionCopy: List[zio.aws.dlm.model.CrossRegionCopyAction.ReadOnly]
    def getName: ZIO[Any, Nothing, ActionName] = ZIO.succeed(name)
    def getCrossRegionCopy: ZIO[Any, Nothing, List[
      zio.aws.dlm.model.CrossRegionCopyAction.ReadOnly
    ]] = ZIO.succeed(crossRegionCopy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.Action
  ) extends zio.aws.dlm.model.Action.ReadOnly {
    override val name: ActionName =
      zio.aws.dlm.model.primitives.ActionName(impl.name())
    override val crossRegionCopy
        : List[zio.aws.dlm.model.CrossRegionCopyAction.ReadOnly] = impl
      .crossRegionCopy()
      .asScala
      .map { item =>
        zio.aws.dlm.model.CrossRegionCopyAction.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.Action
  ): zio.aws.dlm.model.Action.ReadOnly = new Wrapper(impl)
}
