package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{
  TagValue,
  TagKey,
  PolicyDescription,
  ExecutionRoleArn
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLifecyclePolicyRequest(
    executionRoleArn: ExecutionRoleArn,
    description: PolicyDescription,
    state: zio.aws.dlm.model.SettablePolicyStateValues,
    policyDetails: zio.aws.dlm.model.PolicyDetails,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyRequest = {
    import CreateLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyRequest
      .builder()
      .executionRoleArn(
        ExecutionRoleArn.unwrap(executionRoleArn): java.lang.String
      )
      .description(PolicyDescription.unwrap(description): java.lang.String)
      .state(state.unwrap)
      .policyDetails(policyDetails.buildAwsValue())
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.CreateLifecyclePolicyRequest.ReadOnly =
    zio.aws.dlm.model.CreateLifecyclePolicyRequest.wrap(buildAwsValue())
}
object CreateLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.CreateLifecyclePolicyRequest =
      zio.aws.dlm.model.CreateLifecyclePolicyRequest(
        executionRoleArn,
        description,
        state,
        policyDetails.asEditable,
        tags.map(value => value)
      )
    def executionRoleArn: ExecutionRoleArn
    def description: PolicyDescription
    def state: zio.aws.dlm.model.SettablePolicyStateValues
    def policyDetails: zio.aws.dlm.model.PolicyDetails.ReadOnly
    def tags: Optional[Map[TagKey, TagValue]]
    def getExecutionRoleArn: ZIO[Any, Nothing, ExecutionRoleArn] =
      ZIO.succeed(executionRoleArn)
    def getDescription: ZIO[Any, Nothing, PolicyDescription] =
      ZIO.succeed(description)
    def getState
        : ZIO[Any, Nothing, zio.aws.dlm.model.SettablePolicyStateValues] =
      ZIO.succeed(state)
    def getPolicyDetails
        : ZIO[Any, Nothing, zio.aws.dlm.model.PolicyDetails.ReadOnly] =
      ZIO.succeed(policyDetails)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyRequest
  ) extends zio.aws.dlm.model.CreateLifecyclePolicyRequest.ReadOnly {
    override val executionRoleArn: ExecutionRoleArn =
      zio.aws.dlm.model.primitives.ExecutionRoleArn(impl.executionRoleArn())
    override val description: PolicyDescription =
      zio.aws.dlm.model.primitives.PolicyDescription(impl.description())
    override val state: zio.aws.dlm.model.SettablePolicyStateValues =
      zio.aws.dlm.model.SettablePolicyStateValues.wrap(impl.state())
    override val policyDetails: zio.aws.dlm.model.PolicyDetails.ReadOnly =
      zio.aws.dlm.model.PolicyDetails.wrap(impl.policyDetails())
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dlm.model.primitives
              .TagKey(key) -> zio.aws.dlm.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyRequest
  ): zio.aws.dlm.model.CreateLifecyclePolicyRequest.ReadOnly = new Wrapper(impl)
}
