package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.Target
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CrossRegionCopyAction(
    target: Target,
    encryptionConfiguration: zio.aws.dlm.model.EncryptionConfiguration,
    retainRule: Optional[zio.aws.dlm.model.CrossRegionCopyRetainRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.CrossRegionCopyAction = {
    import CrossRegionCopyAction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.CrossRegionCopyAction
      .builder()
      .target(Target.unwrap(target): java.lang.String)
      .encryptionConfiguration(encryptionConfiguration.buildAwsValue())
      .optionallyWith(retainRule.map(value => value.buildAwsValue()))(
        _.retainRule
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.CrossRegionCopyAction.ReadOnly =
    zio.aws.dlm.model.CrossRegionCopyAction.wrap(buildAwsValue())
}
object CrossRegionCopyAction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.CrossRegionCopyAction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.CrossRegionCopyAction =
      zio.aws.dlm.model.CrossRegionCopyAction(
        target,
        encryptionConfiguration.asEditable,
        retainRule.map(value => value.asEditable)
      )
    def target: Target
    def encryptionConfiguration
        : zio.aws.dlm.model.EncryptionConfiguration.ReadOnly
    def retainRule
        : Optional[zio.aws.dlm.model.CrossRegionCopyRetainRule.ReadOnly]
    def getTarget: ZIO[Any, Nothing, Target] = ZIO.succeed(target)
    def getEncryptionConfiguration: ZIO[
      Any,
      Nothing,
      zio.aws.dlm.model.EncryptionConfiguration.ReadOnly
    ] = ZIO.succeed(encryptionConfiguration)
    def getRetainRule: ZIO[
      Any,
      AwsError,
      zio.aws.dlm.model.CrossRegionCopyRetainRule.ReadOnly
    ] = AwsError.unwrapOptionField("retainRule", retainRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.CrossRegionCopyAction
  ) extends zio.aws.dlm.model.CrossRegionCopyAction.ReadOnly {
    override val target: Target =
      zio.aws.dlm.model.primitives.Target(impl.target())
    override val encryptionConfiguration
        : zio.aws.dlm.model.EncryptionConfiguration.ReadOnly =
      zio.aws.dlm.model.EncryptionConfiguration
        .wrap(impl.encryptionConfiguration())
    override val retainRule
        : Optional[zio.aws.dlm.model.CrossRegionCopyRetainRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainRule())
        .map(value => zio.aws.dlm.model.CrossRegionCopyRetainRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.CrossRegionCopyAction
  ): zio.aws.dlm.model.CrossRegionCopyAction.ReadOnly = new Wrapper(impl)
}
