package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.Interval
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CrossRegionCopyDeprecateRule(
    interval: Optional[Interval] = Optional.Absent,
    intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.CrossRegionCopyDeprecateRule = {
    import CrossRegionCopyDeprecateRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.CrossRegionCopyDeprecateRule
      .builder()
      .optionallyWith(interval.map(value => Interval.unwrap(value): Integer))(
        _.interval
      )
      .optionallyWith(intervalUnit.map(value => value.unwrap))(_.intervalUnit)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.CrossRegionCopyDeprecateRule.ReadOnly =
    zio.aws.dlm.model.CrossRegionCopyDeprecateRule.wrap(buildAwsValue())
}
object CrossRegionCopyDeprecateRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.CrossRegionCopyDeprecateRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.CrossRegionCopyDeprecateRule =
      zio.aws.dlm.model.CrossRegionCopyDeprecateRule(
        interval.map(value => value),
        intervalUnit.map(value => value)
      )
    def interval: Optional[Interval]
    def intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues]
    def getInterval: ZIO[Any, AwsError, Interval] =
      AwsError.unwrapOptionField("interval", interval)
    def getIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetentionIntervalUnitValues] =
      AwsError.unwrapOptionField("intervalUnit", intervalUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.CrossRegionCopyDeprecateRule
  ) extends zio.aws.dlm.model.CrossRegionCopyDeprecateRule.ReadOnly {
    override val interval: Optional[Interval] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.dlm.model.primitives.Interval(value))
    override val intervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalUnit())
        .map(value => zio.aws.dlm.model.RetentionIntervalUnitValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.CrossRegionCopyDeprecateRule
  ): zio.aws.dlm.model.CrossRegionCopyDeprecateRule.ReadOnly = new Wrapper(impl)
}
