package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{TagFilter, PolicyId}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLifecyclePoliciesRequest(
    policyIds: Optional[Iterable[PolicyId]] = Optional.Absent,
    state: Optional[zio.aws.dlm.model.GettablePolicyStateValues] =
      Optional.Absent,
    resourceTypes: Optional[Iterable[zio.aws.dlm.model.ResourceTypeValues]] =
      Optional.Absent,
    targetTags: Optional[Iterable[TagFilter]] = Optional.Absent,
    tagsToAdd: Optional[Iterable[TagFilter]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesRequest = {
    import GetLifecyclePoliciesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesRequest
      .builder()
      .optionallyWith(
        policyIds.map(value =>
          value.map { item =>
            PolicyId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.policyIds)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .optionallyWith(
        targetTags.map(value =>
          value.map { item =>
            TagFilter.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.targetTags)
      .optionallyWith(
        tagsToAdd.map(value =>
          value.map { item =>
            TagFilter.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.tagsToAdd)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.GetLifecyclePoliciesRequest.ReadOnly =
    zio.aws.dlm.model.GetLifecyclePoliciesRequest.wrap(buildAwsValue())
}
object GetLifecyclePoliciesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.GetLifecyclePoliciesRequest =
      zio.aws.dlm.model.GetLifecyclePoliciesRequest(
        policyIds.map(value => value),
        state.map(value => value),
        resourceTypes.map(value => value),
        targetTags.map(value => value),
        tagsToAdd.map(value => value)
      )
    def policyIds: Optional[List[PolicyId]]
    def state: Optional[zio.aws.dlm.model.GettablePolicyStateValues]
    def resourceTypes: Optional[List[zio.aws.dlm.model.ResourceTypeValues]]
    def targetTags: Optional[List[TagFilter]]
    def tagsToAdd: Optional[List[TagFilter]]
    def getPolicyIds: ZIO[Any, AwsError, List[PolicyId]] =
      AwsError.unwrapOptionField("policyIds", policyIds)
    def getState
        : ZIO[Any, AwsError, zio.aws.dlm.model.GettablePolicyStateValues] =
      AwsError.unwrapOptionField("state", state)
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.ResourceTypeValues]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getTargetTags: ZIO[Any, AwsError, List[TagFilter]] =
      AwsError.unwrapOptionField("targetTags", targetTags)
    def getTagsToAdd: ZIO[Any, AwsError, List[TagFilter]] =
      AwsError.unwrapOptionField("tagsToAdd", tagsToAdd)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesRequest
  ) extends zio.aws.dlm.model.GetLifecyclePoliciesRequest.ReadOnly {
    override val policyIds: Optional[List[PolicyId]] = zio.aws.core.internal
      .optionalFromNullable(impl.policyIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dlm.model.primitives.PolicyId(item)
        }.toList
      )
    override val state: Optional[zio.aws.dlm.model.GettablePolicyStateValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.dlm.model.GettablePolicyStateValues.wrap(value))
    override val resourceTypes
        : Optional[List[zio.aws.dlm.model.ResourceTypeValues]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.ResourceTypeValues.wrap(item)
          }.toList
        )
    override val targetTags: Optional[List[TagFilter]] = zio.aws.core.internal
      .optionalFromNullable(impl.targetTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dlm.model.primitives.TagFilter(item)
        }.toList
      )
    override val tagsToAdd: Optional[List[TagFilter]] = zio.aws.core.internal
      .optionalFromNullable(impl.tagsToAdd())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dlm.model.primitives.TagFilter(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesRequest
  ): zio.aws.dlm.model.GetLifecyclePoliciesRequest.ReadOnly = new Wrapper(impl)
}
