package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.PolicyId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetLifecyclePolicyRequest(policyId: PolicyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyRequest = {
    import GetLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.GetLifecyclePolicyRequest.ReadOnly =
    zio.aws.dlm.model.GetLifecyclePolicyRequest.wrap(buildAwsValue())
}
object GetLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.GetLifecyclePolicyRequest =
      zio.aws.dlm.model.GetLifecyclePolicyRequest(policyId)
    def policyId: PolicyId
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyRequest
  ) extends zio.aws.dlm.model.GetLifecyclePolicyRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.dlm.model.primitives.PolicyId(impl.policyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyRequest
  ): zio.aws.dlm.model.GetLifecyclePolicyRequest.ReadOnly = new Wrapper(impl)
}
