package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLifecyclePolicyResponse(
    policy: Optional[zio.aws.dlm.model.LifecyclePolicy] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyResponse = {
    import GetLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyResponse
      .builder()
      .optionallyWith(policy.map(value => value.buildAwsValue()))(_.policy)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly =
    zio.aws.dlm.model.GetLifecyclePolicyResponse.wrap(buildAwsValue())
}
object GetLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.GetLifecyclePolicyResponse =
      zio.aws.dlm.model
        .GetLifecyclePolicyResponse(policy.map(value => value.asEditable))
    def policy: Optional[zio.aws.dlm.model.LifecyclePolicy.ReadOnly]
    def getPolicy
        : ZIO[Any, AwsError, zio.aws.dlm.model.LifecyclePolicy.ReadOnly] =
      AwsError.unwrapOptionField("policy", policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyResponse
  ) extends zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly {
    override val policy: Optional[zio.aws.dlm.model.LifecyclePolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policy())
        .map(value => zio.aws.dlm.model.LifecyclePolicy.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyResponse
  ): zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly = new Wrapper(impl)
}
