package zio.aws.dlm.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{
  ExecutionRoleArn,
  PolicyArn,
  Timestamp,
  TagValue,
  PolicyDescription,
  PolicyId,
  StatusMessage,
  TagKey
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicy(
    policyId: Optional[PolicyId] = Optional.Absent,
    description: Optional[PolicyDescription] = Optional.Absent,
    state: Optional[zio.aws.dlm.model.GettablePolicyStateValues] =
      Optional.Absent,
    statusMessage: Optional[StatusMessage] = Optional.Absent,
    executionRoleArn: Optional[ExecutionRoleArn] = Optional.Absent,
    dateCreated: Optional[Timestamp] = Optional.Absent,
    dateModified: Optional[Timestamp] = Optional.Absent,
    policyDetails: Optional[zio.aws.dlm.model.PolicyDetails] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    policyArn: Optional[PolicyArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.LifecyclePolicy = {
    import LifecyclePolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.LifecyclePolicy
      .builder()
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        description.map(value =>
          PolicyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        statusMessage.map(value =>
          StatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        executionRoleArn.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(
        dateCreated.map(value => Timestamp.unwrap(value): Instant)
      )(_.dateCreated)
      .optionallyWith(
        dateModified.map(value => Timestamp.unwrap(value): Instant)
      )(_.dateModified)
      .optionallyWith(policyDetails.map(value => value.buildAwsValue()))(
        _.policyDetails
      )
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(
        policyArn.map(value => PolicyArn.unwrap(value): java.lang.String)
      )(_.policyArn)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.LifecyclePolicy.ReadOnly =
    zio.aws.dlm.model.LifecyclePolicy.wrap(buildAwsValue())
}
object LifecyclePolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.LifecyclePolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.LifecyclePolicy =
      zio.aws.dlm.model.LifecyclePolicy(
        policyId.map(value => value),
        description.map(value => value),
        state.map(value => value),
        statusMessage.map(value => value),
        executionRoleArn.map(value => value),
        dateCreated.map(value => value),
        dateModified.map(value => value),
        policyDetails.map(value => value.asEditable),
        tags.map(value => value),
        policyArn.map(value => value)
      )
    def policyId: Optional[PolicyId]
    def description: Optional[PolicyDescription]
    def state: Optional[zio.aws.dlm.model.GettablePolicyStateValues]
    def statusMessage: Optional[StatusMessage]
    def executionRoleArn: Optional[ExecutionRoleArn]
    def dateCreated: Optional[Timestamp]
    def dateModified: Optional[Timestamp]
    def policyDetails: Optional[zio.aws.dlm.model.PolicyDetails.ReadOnly]
    def tags: Optional[Map[TagKey, TagValue]]
    def policyArn: Optional[PolicyArn]
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getDescription: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState
        : ZIO[Any, AwsError, zio.aws.dlm.model.GettablePolicyStateValues] =
      AwsError.unwrapOptionField("state", state)
    def getStatusMessage: ZIO[Any, AwsError, StatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getExecutionRoleArn: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getDateCreated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dateCreated", dateCreated)
    def getDateModified: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("dateModified", dateModified)
    def getPolicyDetails
        : ZIO[Any, AwsError, zio.aws.dlm.model.PolicyDetails.ReadOnly] =
      AwsError.unwrapOptionField("policyDetails", policyDetails)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPolicyArn: ZIO[Any, AwsError, PolicyArn] =
      AwsError.unwrapOptionField("policyArn", policyArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.LifecyclePolicy
  ) extends zio.aws.dlm.model.LifecyclePolicy.ReadOnly {
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.dlm.model.primitives.PolicyId(value))
    override val description: Optional[PolicyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.dlm.model.primitives.PolicyDescription(value))
    override val state: Optional[zio.aws.dlm.model.GettablePolicyStateValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.dlm.model.GettablePolicyStateValues.wrap(value))
    override val statusMessage: Optional[StatusMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.statusMessage())
      .map(value => zio.aws.dlm.model.primitives.StatusMessage(value))
    override val executionRoleArn: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleArn())
        .map(value => zio.aws.dlm.model.primitives.ExecutionRoleArn(value))
    override val dateCreated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dateCreated())
      .map(value => zio.aws.dlm.model.primitives.Timestamp(value))
    override val dateModified: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.dateModified())
      .map(value => zio.aws.dlm.model.primitives.Timestamp(value))
    override val policyDetails
        : Optional[zio.aws.dlm.model.PolicyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDetails())
        .map(value => zio.aws.dlm.model.PolicyDetails.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dlm.model.primitives
              .TagKey(key) -> zio.aws.dlm.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val policyArn: Optional[PolicyArn] = zio.aws.core.internal
      .optionalFromNullable(impl.policyArn())
      .map(value => zio.aws.dlm.model.primitives.PolicyArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.LifecyclePolicy
  ): zio.aws.dlm.model.LifecyclePolicy.ReadOnly = new Wrapper(impl)
}
