package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{
  TagValue,
  TagKey,
  PolicyDescription,
  PolicyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class LifecyclePolicySummary(
    policyId: Optional[PolicyId] = Optional.Absent,
    description: Optional[PolicyDescription] = Optional.Absent,
    state: Optional[zio.aws.dlm.model.GettablePolicyStateValues] =
      Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent,
    policyType: Optional[zio.aws.dlm.model.PolicyTypeValues] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.LifecyclePolicySummary = {
    import LifecyclePolicySummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.LifecyclePolicySummary
      .builder()
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .optionallyWith(
        description.map(value =>
          PolicyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.LifecyclePolicySummary.ReadOnly =
    zio.aws.dlm.model.LifecyclePolicySummary.wrap(buildAwsValue())
}
object LifecyclePolicySummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.LifecyclePolicySummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.LifecyclePolicySummary =
      zio.aws.dlm.model.LifecyclePolicySummary(
        policyId.map(value => value),
        description.map(value => value),
        state.map(value => value),
        tags.map(value => value),
        policyType.map(value => value)
      )
    def policyId: Optional[PolicyId]
    def description: Optional[PolicyDescription]
    def state: Optional[zio.aws.dlm.model.GettablePolicyStateValues]
    def tags: Optional[Map[TagKey, TagValue]]
    def policyType: Optional[zio.aws.dlm.model.PolicyTypeValues]
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
    def getDescription: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getState
        : ZIO[Any, AwsError, zio.aws.dlm.model.GettablePolicyStateValues] =
      AwsError.unwrapOptionField("state", state)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
    def getPolicyType: ZIO[Any, AwsError, zio.aws.dlm.model.PolicyTypeValues] =
      AwsError.unwrapOptionField("policyType", policyType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.LifecyclePolicySummary
  ) extends zio.aws.dlm.model.LifecyclePolicySummary.ReadOnly {
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.dlm.model.primitives.PolicyId(value))
    override val description: Optional[PolicyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.dlm.model.primitives.PolicyDescription(value))
    override val state: Optional[zio.aws.dlm.model.GettablePolicyStateValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.dlm.model.GettablePolicyStateValues.wrap(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.dlm.model.primitives
              .TagKey(key) -> zio.aws.dlm.model.primitives.TagValue(value)
          })
          .toMap
      )
    override val policyType: Optional[zio.aws.dlm.model.PolicyTypeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyType())
        .map(value => zio.aws.dlm.model.PolicyTypeValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.LifecyclePolicySummary
  ): zio.aws.dlm.model.LifecyclePolicySummary.ReadOnly = new Wrapper(impl)
}
