package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{NoReboot, ExcludeBootVolume}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Parameters(
    excludeBootVolume: Optional[ExcludeBootVolume] = Optional.Absent,
    noReboot: Optional[NoReboot] = Optional.Absent,
    excludeDataVolumeTags: Optional[Iterable[zio.aws.dlm.model.Tag]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.Parameters = {
    import Parameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.Parameters
      .builder()
      .optionallyWith(
        excludeBootVolume.map(value =>
          ExcludeBootVolume.unwrap(value): java.lang.Boolean
        )
      )(_.excludeBootVolume)
      .optionallyWith(
        noReboot.map(value => NoReboot.unwrap(value): java.lang.Boolean)
      )(_.noReboot)
      .optionallyWith(
        excludeDataVolumeTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.excludeDataVolumeTags)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.Parameters.ReadOnly =
    zio.aws.dlm.model.Parameters.wrap(buildAwsValue())
}
object Parameters {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.Parameters] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.Parameters = zio.aws.dlm.model.Parameters(
      excludeBootVolume.map(value => value),
      noReboot.map(value => value),
      excludeDataVolumeTags.map(value =>
        value.map { item =>
          item.asEditable
        }
      )
    )
    def excludeBootVolume: Optional[ExcludeBootVolume]
    def noReboot: Optional[NoReboot]
    def excludeDataVolumeTags: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]]
    def getExcludeBootVolume: ZIO[Any, AwsError, ExcludeBootVolume] =
      AwsError.unwrapOptionField("excludeBootVolume", excludeBootVolume)
    def getNoReboot: ZIO[Any, AwsError, NoReboot] =
      AwsError.unwrapOptionField("noReboot", noReboot)
    def getExcludeDataVolumeTags
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("excludeDataVolumeTags", excludeDataVolumeTags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.Parameters
  ) extends zio.aws.dlm.model.Parameters.ReadOnly {
    override val excludeBootVolume: Optional[ExcludeBootVolume] =
      zio.aws.core.internal
        .optionalFromNullable(impl.excludeBootVolume())
        .map(value => zio.aws.dlm.model.primitives.ExcludeBootVolume(value))
    override val noReboot: Optional[NoReboot] = zio.aws.core.internal
      .optionalFromNullable(impl.noReboot())
      .map(value => zio.aws.dlm.model.primitives.NoReboot(value))
    override val excludeDataVolumeTags
        : Optional[List[zio.aws.dlm.model.Tag.ReadOnly]] = zio.aws.core.internal
      .optionalFromNullable(impl.excludeDataVolumeTags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dlm.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.Parameters
  ): zio.aws.dlm.model.Parameters.ReadOnly = new Wrapper(impl)
}
