package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceTypeValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.ResourceTypeValues
}
object ResourceTypeValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.ResourceTypeValues
  ): zio.aws.dlm.model.ResourceTypeValues = value match {
    case software.amazon.awssdk.services.dlm.model.ResourceTypeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.ResourceTypeValues.VOLUME =>
      val r = VOLUME
      r
    case software.amazon.awssdk.services.dlm.model.ResourceTypeValues.INSTANCE =>
      val r = INSTANCE
      r
  }
  case object unknownToSdkVersion extends zio.aws.dlm.model.ResourceTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.ResourceTypeValues =
      software.amazon.awssdk.services.dlm.model.ResourceTypeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object VOLUME extends zio.aws.dlm.model.ResourceTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.ResourceTypeValues =
      software.amazon.awssdk.services.dlm.model.ResourceTypeValues.VOLUME
  }
  case object INSTANCE extends zio.aws.dlm.model.ResourceTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.ResourceTypeValues =
      software.amazon.awssdk.services.dlm.model.ResourceTypeValues.INSTANCE
  }
}
