package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{Interval, AwsAccountId}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ShareRule(
    targetAccounts: Iterable[AwsAccountId],
    unshareInterval: Optional[Interval] = Optional.Absent,
    unshareIntervalUnit: Optional[
      zio.aws.dlm.model.RetentionIntervalUnitValues
    ] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.ShareRule = {
    import ShareRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.ShareRule
      .builder()
      .targetAccounts(targetAccounts.map { item =>
        AwsAccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        unshareInterval.map(value => Interval.unwrap(value): Integer)
      )(_.unshareInterval)
      .optionallyWith(unshareIntervalUnit.map(value => value.unwrap))(
        _.unshareIntervalUnit
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.ShareRule.ReadOnly =
    zio.aws.dlm.model.ShareRule.wrap(buildAwsValue())
}
object ShareRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.ShareRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.ShareRule = zio.aws.dlm.model.ShareRule(
      targetAccounts,
      unshareInterval.map(value => value),
      unshareIntervalUnit.map(value => value)
    )
    def targetAccounts: List[AwsAccountId]
    def unshareInterval: Optional[Interval]
    def unshareIntervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues]
    def getTargetAccounts: ZIO[Any, Nothing, List[AwsAccountId]] =
      ZIO.succeed(targetAccounts)
    def getUnshareInterval: ZIO[Any, AwsError, Interval] =
      AwsError.unwrapOptionField("unshareInterval", unshareInterval)
    def getUnshareIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetentionIntervalUnitValues] =
      AwsError.unwrapOptionField("unshareIntervalUnit", unshareIntervalUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.ShareRule
  ) extends zio.aws.dlm.model.ShareRule.ReadOnly {
    override val targetAccounts: List[AwsAccountId] = impl
      .targetAccounts()
      .asScala
      .map { item =>
        zio.aws.dlm.model.primitives.AwsAccountId(item)
      }
      .toList
    override val unshareInterval: Optional[Interval] = zio.aws.core.internal
      .optionalFromNullable(impl.unshareInterval())
      .map(value => zio.aws.dlm.model.primitives.Interval(value))
    override val unshareIntervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.unshareIntervalUnit())
        .map(value => zio.aws.dlm.model.RetentionIntervalUnitValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.ShareRule
  ): zio.aws.dlm.model.ShareRule.ReadOnly = new Wrapper(impl)
}
