package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Tag(key: String, value: String) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.Tag = {
    import Tag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.Tag
      .builder()
      .key(key: java.lang.String)
      .value(value: java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.Tag.ReadOnly =
    zio.aws.dlm.model.Tag.wrap(buildAwsValue())
}
object Tag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.Tag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.Tag = zio.aws.dlm.model.Tag(key, value)
    def key: String
    def value: String
    def getKey: ZIO[Any, Nothing, String] = ZIO.succeed(key)
    def getValue: ZIO[Any, Nothing, String] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.Tag
  ) extends zio.aws.dlm.model.Tag.ReadOnly {
    override val key: String = impl.key(): String
    override val value: String = impl.value(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.Tag
  ): zio.aws.dlm.model.Tag.ReadOnly = new Wrapper(impl)
}
