package zio.aws.dlm
import zio.aws.dlm.model.TagResourceResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import software.amazon.awssdk.services.dlm.{
  DlmAsyncClientBuilder,
  DlmAsyncClient
}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.dlm.model.{
  GetLifecyclePoliciesRequest,
  ListTagsForResourceRequest,
  CreateLifecyclePolicyRequest,
  DeleteLifecyclePolicyRequest,
  UntagResourceRequest,
  GetLifecyclePolicyRequest,
  TagResourceRequest,
  UpdateLifecyclePolicyRequest
}
import software.amazon.awssdk.services.dlm.model.{
  CreateLifecyclePolicyResponse,
  DeleteLifecyclePolicyResponse,
  UpdateLifecyclePolicyResponse,
  ListTagsForResourceResponse,
  UntagResourceResponse,
  GetLifecyclePolicyResponse,
  GetLifecyclePoliciesResponse,
  TagResourceResponse
}
import scala.jdk.CollectionConverters.*
trait Dlm extends AspectSupport[Dlm] {
  val api: DlmAsyncClient
  def deleteLifecyclePolicy(
      request: DeleteLifecyclePolicyRequest
  ): IO[AwsError, zio.aws.dlm.model.DeleteLifecyclePolicyResponse.ReadOnly]
  def untagResource(
      request: UntagResourceRequest
  ): IO[AwsError, zio.aws.dlm.model.UntagResourceResponse.ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.dlm.model.ListTagsForResourceResponse.ReadOnly]
  def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly]
  def createLifecyclePolicy(
      request: CreateLifecyclePolicyRequest
  ): IO[AwsError, zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly]
  def getLifecyclePolicies(
      request: GetLifecyclePoliciesRequest
  ): IO[AwsError, zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly]
  def getLifecyclePolicy(
      request: GetLifecyclePolicyRequest
  ): IO[AwsError, zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly]
  def updateLifecyclePolicy(
      request: UpdateLifecyclePolicyRequest
  ): IO[AwsError, zio.aws.dlm.model.UpdateLifecyclePolicyResponse.ReadOnly]
}
object Dlm {
  val live: ZLayer[AwsConfig, java.lang.Throwable, Dlm] = customized(identity)
  def customized(
      customization: DlmAsyncClientBuilder => DlmAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, Dlm] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DlmAsyncClientBuilder => DlmAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, Dlm] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DlmAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[DlmAsyncClient, DlmAsyncClientBuilder](builder);
    b1 <- awsConfig.configureHttpClient[DlmAsyncClient, DlmAsyncClientBuilder](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DlmImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DlmImpl[R](
      override val api: DlmAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends Dlm
      with AwsServiceBase[R] {
    override val serviceName: String = "Dlm"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DlmImpl[R1] = new DlmImpl(api, newAspect, r)
    def deleteLifecyclePolicy(
        request: DeleteLifecyclePolicyRequest
    ): IO[AwsError, zio.aws.dlm.model.DeleteLifecyclePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.DeleteLifecyclePolicyRequest,
        DeleteLifecyclePolicyResponse
      ]("deleteLifecyclePolicy", api.deleteLifecyclePolicy)(
        request.buildAwsValue()
      ).map(zio.aws.dlm.model.DeleteLifecyclePolicyResponse.wrap)
        .provideEnvironment(r)
    def untagResource(
        request: UntagResourceRequest
    ): IO[AwsError, zio.aws.dlm.model.UntagResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.UntagResourceRequest,
        UntagResourceResponse
      ]("untagResource", api.untagResource)(request.buildAwsValue())
        .map(zio.aws.dlm.model.UntagResourceResponse.wrap)
        .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.dlm.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.dlm.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def tagResource(request: TagResourceRequest): IO[AwsError, ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.TagResourceRequest,
        TagResourceResponse
      ]("tagResource", api.tagResource)(request.buildAwsValue())
        .map(zio.aws.dlm.model.TagResourceResponse.wrap)
        .provideEnvironment(r)
    def createLifecyclePolicy(
        request: CreateLifecyclePolicyRequest
    ): IO[AwsError, zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyRequest,
        CreateLifecyclePolicyResponse
      ]("createLifecyclePolicy", api.createLifecyclePolicy)(
        request.buildAwsValue()
      ).map(zio.aws.dlm.model.CreateLifecyclePolicyResponse.wrap)
        .provideEnvironment(r)
    def getLifecyclePolicies(
        request: GetLifecyclePoliciesRequest
    ): IO[AwsError, zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesRequest,
        GetLifecyclePoliciesResponse
      ]("getLifecyclePolicies", api.getLifecyclePolicies)(
        request.buildAwsValue()
      ).map(zio.aws.dlm.model.GetLifecyclePoliciesResponse.wrap)
        .provideEnvironment(r)
    def getLifecyclePolicy(
        request: GetLifecyclePolicyRequest
    ): IO[AwsError, zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.GetLifecyclePolicyRequest,
        GetLifecyclePolicyResponse
      ]("getLifecyclePolicy", api.getLifecyclePolicy)(request.buildAwsValue())
        .map(zio.aws.dlm.model.GetLifecyclePolicyResponse.wrap)
        .provideEnvironment(r)
    def updateLifecyclePolicy(
        request: UpdateLifecyclePolicyRequest
    ): IO[AwsError, zio.aws.dlm.model.UpdateLifecyclePolicyResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.dlm.model.UpdateLifecyclePolicyRequest,
        UpdateLifecyclePolicyResponse
      ]("updateLifecyclePolicy", api.updateLifecyclePolicy)(
        request.buildAwsValue()
      ).map(zio.aws.dlm.model.UpdateLifecyclePolicyResponse.wrap)
        .provideEnvironment(r)
  }
  def deleteLifecyclePolicy(request: DeleteLifecyclePolicyRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.DeleteLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteLifecyclePolicy(request))
  def untagResource(request: UntagResourceRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.UntagResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.untagResource(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def tagResource(
      request: TagResourceRequest
  ): ZIO[zio.aws.dlm.Dlm, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.tagResource(request))
  def createLifecyclePolicy(request: CreateLifecyclePolicyRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createLifecyclePolicy(request))
  def getLifecyclePolicies(request: GetLifecyclePoliciesRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLifecyclePolicies(request))
  def getLifecyclePolicy(request: GetLifecyclePolicyRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getLifecyclePolicy(request))
  def updateLifecyclePolicy(request: UpdateLifecyclePolicyRequest): ZIO[
    zio.aws.dlm.Dlm,
    AwsError,
    zio.aws.dlm.model.UpdateLifecyclePolicyResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateLifecyclePolicy(request))
}
