package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ArchiveRule(retainRule: zio.aws.dlm.model.ArchiveRetainRule) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.ArchiveRule = {
    import ArchiveRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.ArchiveRule
      .builder()
      .retainRule(retainRule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.ArchiveRule.ReadOnly =
    zio.aws.dlm.model.ArchiveRule.wrap(buildAwsValue())
}
object ArchiveRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.ArchiveRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.ArchiveRule =
      zio.aws.dlm.model.ArchiveRule(retainRule.asEditable)
    def retainRule: zio.aws.dlm.model.ArchiveRetainRule.ReadOnly
    def getRetainRule
        : ZIO[Any, Nothing, zio.aws.dlm.model.ArchiveRetainRule.ReadOnly] =
      ZIO.succeed(retainRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.ArchiveRule
  ) extends zio.aws.dlm.model.ArchiveRule.ReadOnly {
    override val retainRule: zio.aws.dlm.model.ArchiveRetainRule.ReadOnly =
      zio.aws.dlm.model.ArchiveRetainRule.wrap(impl.retainRule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.ArchiveRule
  ): zio.aws.dlm.model.ArchiveRule.ReadOnly = new Wrapper(impl)
}
