package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.PolicyId
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateLifecyclePolicyResponse(
    policyId: Optional[PolicyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyResponse = {
    import CreateLifecyclePolicyResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyResponse
      .builder()
      .optionallyWith(
        policyId.map(value => PolicyId.unwrap(value): java.lang.String)
      )(_.policyId)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly =
    zio.aws.dlm.model.CreateLifecyclePolicyResponse.wrap(buildAwsValue())
}
object CreateLifecyclePolicyResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.CreateLifecyclePolicyResponse =
      zio.aws.dlm.model
        .CreateLifecyclePolicyResponse(policyId.map(value => value))
    def policyId: Optional[PolicyId]
    def getPolicyId: ZIO[Any, AwsError, PolicyId] =
      AwsError.unwrapOptionField("policyId", policyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyResponse
  ) extends zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly {
    override val policyId: Optional[PolicyId] = zio.aws.core.internal
      .optionalFromNullable(impl.policyId())
      .map(value => zio.aws.dlm.model.primitives.PolicyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.CreateLifecyclePolicyResponse
  ): zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly = new Wrapper(
    impl
  )
}
