package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{CronExpression, Time, Interval}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class CreateRule(
    location: Optional[zio.aws.dlm.model.LocationValues] = Optional.Absent,
    interval: Optional[Interval] = Optional.Absent,
    intervalUnit: Optional[zio.aws.dlm.model.IntervalUnitValues] =
      Optional.Absent,
    times: Optional[Iterable[Time]] = Optional.Absent,
    cronExpression: Optional[CronExpression] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.CreateRule = {
    import CreateRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.CreateRule
      .builder()
      .optionallyWith(location.map(value => value.unwrap))(_.location)
      .optionallyWith(interval.map(value => Interval.unwrap(value): Integer))(
        _.interval
      )
      .optionallyWith(intervalUnit.map(value => value.unwrap))(_.intervalUnit)
      .optionallyWith(
        times.map(value =>
          value.map { item =>
            Time.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.times)
      .optionallyWith(
        cronExpression.map(value =>
          CronExpression.unwrap(value): java.lang.String
        )
      )(_.cronExpression)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.CreateRule.ReadOnly =
    zio.aws.dlm.model.CreateRule.wrap(buildAwsValue())
}
object CreateRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.CreateRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.CreateRule = zio.aws.dlm.model.CreateRule(
      location.map(value => value),
      interval.map(value => value),
      intervalUnit.map(value => value),
      times.map(value => value),
      cronExpression.map(value => value)
    )
    def location: Optional[zio.aws.dlm.model.LocationValues]
    def interval: Optional[Interval]
    def intervalUnit: Optional[zio.aws.dlm.model.IntervalUnitValues]
    def times: Optional[List[Time]]
    def cronExpression: Optional[CronExpression]
    def getLocation: ZIO[Any, AwsError, zio.aws.dlm.model.LocationValues] =
      AwsError.unwrapOptionField("location", location)
    def getInterval: ZIO[Any, AwsError, Interval] =
      AwsError.unwrapOptionField("interval", interval)
    def getIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.IntervalUnitValues] =
      AwsError.unwrapOptionField("intervalUnit", intervalUnit)
    def getTimes: ZIO[Any, AwsError, List[Time]] =
      AwsError.unwrapOptionField("times", times)
    def getCronExpression: ZIO[Any, AwsError, CronExpression] =
      AwsError.unwrapOptionField("cronExpression", cronExpression)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.CreateRule
  ) extends zio.aws.dlm.model.CreateRule.ReadOnly {
    override val location: Optional[zio.aws.dlm.model.LocationValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.location())
        .map(value => zio.aws.dlm.model.LocationValues.wrap(value))
    override val interval: Optional[Interval] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.dlm.model.primitives.Interval(value))
    override val intervalUnit: Optional[zio.aws.dlm.model.IntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalUnit())
        .map(value => zio.aws.dlm.model.IntervalUnitValues.wrap(value))
    override val times: Optional[List[Time]] = zio.aws.core.internal
      .optionalFromNullable(impl.times())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.dlm.model.primitives.Time(item)
        }.toList
      )
    override val cronExpression: Optional[CronExpression] =
      zio.aws.core.internal
        .optionalFromNullable(impl.cronExpression())
        .map(value => zio.aws.dlm.model.primitives.CronExpression(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.CreateRule
  ): zio.aws.dlm.model.CreateRule.ReadOnly = new Wrapper(impl)
}
