package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{Interval, Count}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class DeprecateRule(
    count: Optional[Count] = Optional.Absent,
    interval: Optional[Interval] = Optional.Absent,
    intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.DeprecateRule = {
    import DeprecateRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.DeprecateRule
      .builder()
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .optionallyWith(interval.map(value => Interval.unwrap(value): Integer))(
        _.interval
      )
      .optionallyWith(intervalUnit.map(value => value.unwrap))(_.intervalUnit)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.DeprecateRule.ReadOnly =
    zio.aws.dlm.model.DeprecateRule.wrap(buildAwsValue())
}
object DeprecateRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.DeprecateRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.DeprecateRule =
      zio.aws.dlm.model.DeprecateRule(
        count.map(value => value),
        interval.map(value => value),
        intervalUnit.map(value => value)
      )
    def count: Optional[Count]
    def interval: Optional[Interval]
    def intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues]
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
    def getInterval: ZIO[Any, AwsError, Interval] =
      AwsError.unwrapOptionField("interval", interval)
    def getIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetentionIntervalUnitValues] =
      AwsError.unwrapOptionField("intervalUnit", intervalUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.DeprecateRule
  ) extends zio.aws.dlm.model.DeprecateRule.ReadOnly {
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.dlm.model.primitives.Count(value))
    override val interval: Optional[Interval] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.dlm.model.primitives.Interval(value))
    override val intervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalUnit())
        .map(value => zio.aws.dlm.model.RetentionIntervalUnitValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.DeprecateRule
  ): zio.aws.dlm.model.DeprecateRule.ReadOnly = new Wrapper(impl)
}
