package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{DescriptionRegex, AwsAccountId}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class EventParameters(
    eventType: zio.aws.dlm.model.EventTypeValues,
    snapshotOwner: Iterable[AwsAccountId],
    descriptionRegex: DescriptionRegex
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.EventParameters = {
    import EventParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.EventParameters
      .builder()
      .eventType(eventType.unwrap)
      .snapshotOwner(snapshotOwner.map { item =>
        AwsAccountId.unwrap(item): java.lang.String
      }.asJavaCollection)
      .descriptionRegex(
        DescriptionRegex.unwrap(descriptionRegex): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.EventParameters.ReadOnly =
    zio.aws.dlm.model.EventParameters.wrap(buildAwsValue())
}
object EventParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.EventParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.EventParameters = zio.aws.dlm.model
      .EventParameters(eventType, snapshotOwner, descriptionRegex)
    def eventType: zio.aws.dlm.model.EventTypeValues
    def snapshotOwner: List[AwsAccountId]
    def descriptionRegex: DescriptionRegex
    def getEventType: ZIO[Any, Nothing, zio.aws.dlm.model.EventTypeValues] =
      ZIO.succeed(eventType)
    def getSnapshotOwner: ZIO[Any, Nothing, List[AwsAccountId]] =
      ZIO.succeed(snapshotOwner)
    def getDescriptionRegex: ZIO[Any, Nothing, DescriptionRegex] =
      ZIO.succeed(descriptionRegex)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.EventParameters
  ) extends zio.aws.dlm.model.EventParameters.ReadOnly {
    override val eventType: zio.aws.dlm.model.EventTypeValues =
      zio.aws.dlm.model.EventTypeValues.wrap(impl.eventType())
    override val snapshotOwner: List[AwsAccountId] = impl
      .snapshotOwner()
      .asScala
      .map { item =>
        zio.aws.dlm.model.primitives.AwsAccountId(item)
      }
      .toList
    override val descriptionRegex: DescriptionRegex =
      zio.aws.dlm.model.primitives.DescriptionRegex(impl.descriptionRegex())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.EventParameters
  ): zio.aws.dlm.model.EventParameters.ReadOnly = new Wrapper(impl)
}
