package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait EventSourceValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.EventSourceValues
}
object EventSourceValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.EventSourceValues
  ): zio.aws.dlm.model.EventSourceValues = value match {
    case software.amazon.awssdk.services.dlm.model.EventSourceValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.EventSourceValues.MANAGED_CWE =>
      val r = MANAGED_CWE
      r
  }
  case object unknownToSdkVersion extends zio.aws.dlm.model.EventSourceValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.EventSourceValues =
      software.amazon.awssdk.services.dlm.model.EventSourceValues.UNKNOWN_TO_SDK_VERSION
  }
  case object MANAGED_CWE extends zio.aws.dlm.model.EventSourceValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.EventSourceValues =
      software.amazon.awssdk.services.dlm.model.EventSourceValues.MANAGED_CWE
  }
}
