package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait EventTypeValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.EventTypeValues
}
object EventTypeValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.EventTypeValues
  ): zio.aws.dlm.model.EventTypeValues = value match {
    case software.amazon.awssdk.services.dlm.model.EventTypeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.EventTypeValues.SHARE_SNAPSHOT =>
      val r = shareSnapshot
      r
  }
  case object unknownToSdkVersion extends zio.aws.dlm.model.EventTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.EventTypeValues =
      software.amazon.awssdk.services.dlm.model.EventTypeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object shareSnapshot extends zio.aws.dlm.model.EventTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.EventTypeValues =
      software.amazon.awssdk.services.dlm.model.EventTypeValues.SHARE_SNAPSHOT
  }
}
