package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{AvailabilityZone, Interval, Count}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class FastRestoreRule(
    count: Optional[Count] = Optional.Absent,
    interval: Optional[Interval] = Optional.Absent,
    intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      Optional.Absent,
    availabilityZones: Iterable[AvailabilityZone]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.FastRestoreRule = {
    import FastRestoreRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.FastRestoreRule
      .builder()
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .optionallyWith(interval.map(value => Interval.unwrap(value): Integer))(
        _.interval
      )
      .optionallyWith(intervalUnit.map(value => value.unwrap))(_.intervalUnit)
      .availabilityZones(availabilityZones.map { item =>
        AvailabilityZone.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.FastRestoreRule.ReadOnly =
    zio.aws.dlm.model.FastRestoreRule.wrap(buildAwsValue())
}
object FastRestoreRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.FastRestoreRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.FastRestoreRule =
      zio.aws.dlm.model.FastRestoreRule(
        count.map(value => value),
        interval.map(value => value),
        intervalUnit.map(value => value),
        availabilityZones
      )
    def count: Optional[Count]
    def interval: Optional[Interval]
    def intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues]
    def availabilityZones: List[AvailabilityZone]
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
    def getInterval: ZIO[Any, AwsError, Interval] =
      AwsError.unwrapOptionField("interval", interval)
    def getIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetentionIntervalUnitValues] =
      AwsError.unwrapOptionField("intervalUnit", intervalUnit)
    def getAvailabilityZones: ZIO[Any, Nothing, List[AvailabilityZone]] =
      ZIO.succeed(availabilityZones)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.FastRestoreRule
  ) extends zio.aws.dlm.model.FastRestoreRule.ReadOnly {
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.dlm.model.primitives.Count(value))
    override val interval: Optional[Interval] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.dlm.model.primitives.Interval(value))
    override val intervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalUnit())
        .map(value => zio.aws.dlm.model.RetentionIntervalUnitValues.wrap(value))
    override val availabilityZones: List[AvailabilityZone] = impl
      .availabilityZones()
      .asScala
      .map { item =>
        zio.aws.dlm.model.primitives.AvailabilityZone(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.FastRestoreRule
  ): zio.aws.dlm.model.FastRestoreRule.ReadOnly = new Wrapper(impl)
}
