package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetLifecyclePoliciesResponse(
    policies: Optional[Iterable[zio.aws.dlm.model.LifecyclePolicySummary]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesResponse = {
    import GetLifecyclePoliciesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesResponse
      .builder()
      .optionallyWith(
        policies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.policies)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly =
    zio.aws.dlm.model.GetLifecyclePoliciesResponse.wrap(buildAwsValue())
}
object GetLifecyclePoliciesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.GetLifecyclePoliciesResponse =
      zio.aws.dlm.model.GetLifecyclePoliciesResponse(
        policies.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policies
        : Optional[List[zio.aws.dlm.model.LifecyclePolicySummary.ReadOnly]]
    def getPolicies: ZIO[Any, AwsError, List[
      zio.aws.dlm.model.LifecyclePolicySummary.ReadOnly
    ]] = AwsError.unwrapOptionField("policies", policies)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesResponse
  ) extends zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly {
    override val policies
        : Optional[List[zio.aws.dlm.model.LifecyclePolicySummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.LifecyclePolicySummary.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.GetLifecyclePoliciesResponse
  ): zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly = new Wrapper(impl)
}
