package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait GettablePolicyStateValues {
  def unwrap
      : software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues
}
object GettablePolicyStateValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues
  ): zio.aws.dlm.model.GettablePolicyStateValues = value match {
    case software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.DISABLED =>
      val r = DISABLED
      r
    case software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.ERROR =>
      val r = ERROR
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dlm.model.GettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.dlm.model.GettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.ENABLED
  }
  case object DISABLED extends zio.aws.dlm.model.GettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.DISABLED
  }
  case object ERROR extends zio.aws.dlm.model.GettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.GettablePolicyStateValues.ERROR
  }
}
