package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceLocationValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.ResourceLocationValues
}
object ResourceLocationValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.ResourceLocationValues
  ): zio.aws.dlm.model.ResourceLocationValues = value match {
    case software.amazon.awssdk.services.dlm.model.ResourceLocationValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.ResourceLocationValues.CLOUD =>
      val r = CLOUD
      r
    case software.amazon.awssdk.services.dlm.model.ResourceLocationValues.OUTPOST =>
      val r = OUTPOST
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dlm.model.ResourceLocationValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.ResourceLocationValues =
      software.amazon.awssdk.services.dlm.model.ResourceLocationValues.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUD extends zio.aws.dlm.model.ResourceLocationValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.ResourceLocationValues =
      software.amazon.awssdk.services.dlm.model.ResourceLocationValues.CLOUD
  }
  case object OUTPOST extends zio.aws.dlm.model.ResourceLocationValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.ResourceLocationValues =
      software.amazon.awssdk.services.dlm.model.ResourceLocationValues.OUTPOST
  }
}
