package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{
  StandardTierRetainRuleInterval,
  StandardTierRetainRuleCount
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RetainRule(
    count: Optional[StandardTierRetainRuleCount] = Optional.Absent,
    interval: Optional[StandardTierRetainRuleInterval] = Optional.Absent,
    intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.RetainRule = {
    import RetainRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.RetainRule
      .builder()
      .optionallyWith(
        count.map(value => StandardTierRetainRuleCount.unwrap(value): Integer)
      )(_.count)
      .optionallyWith(
        interval.map(value =>
          StandardTierRetainRuleInterval.unwrap(value): Integer
        )
      )(_.interval)
      .optionallyWith(intervalUnit.map(value => value.unwrap))(_.intervalUnit)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.RetainRule.ReadOnly =
    zio.aws.dlm.model.RetainRule.wrap(buildAwsValue())
}
object RetainRule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.RetainRule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.RetainRule = zio.aws.dlm.model.RetainRule(
      count.map(value => value),
      interval.map(value => value),
      intervalUnit.map(value => value)
    )
    def count: Optional[StandardTierRetainRuleCount]
    def interval: Optional[StandardTierRetainRuleInterval]
    def intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues]
    def getCount: ZIO[Any, AwsError, StandardTierRetainRuleCount] =
      AwsError.unwrapOptionField("count", count)
    def getInterval: ZIO[Any, AwsError, StandardTierRetainRuleInterval] =
      AwsError.unwrapOptionField("interval", interval)
    def getIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetentionIntervalUnitValues] =
      AwsError.unwrapOptionField("intervalUnit", intervalUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.RetainRule
  ) extends zio.aws.dlm.model.RetainRule.ReadOnly {
    override val count: Optional[StandardTierRetainRuleCount] =
      zio.aws.core.internal
        .optionalFromNullable(impl.count())
        .map(value =>
          zio.aws.dlm.model.primitives.StandardTierRetainRuleCount(value)
        )
    override val interval: Optional[StandardTierRetainRuleInterval] =
      zio.aws.core.internal
        .optionalFromNullable(impl.interval())
        .map(value =>
          zio.aws.dlm.model.primitives.StandardTierRetainRuleInterval(value)
        )
    override val intervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalUnit())
        .map(value => zio.aws.dlm.model.RetentionIntervalUnitValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.RetainRule
  ): zio.aws.dlm.model.RetainRule.ReadOnly = new Wrapper(impl)
}
