package zio.aws.dlm.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.dlm.model.primitives.{Interval, Count}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class RetentionArchiveTier(
    count: Optional[Count] = Optional.Absent,
    interval: Optional[Interval] = Optional.Absent,
    intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.RetentionArchiveTier = {
    import RetentionArchiveTier.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.RetentionArchiveTier
      .builder()
      .optionallyWith(count.map(value => Count.unwrap(value): Integer))(_.count)
      .optionallyWith(interval.map(value => Interval.unwrap(value): Integer))(
        _.interval
      )
      .optionallyWith(intervalUnit.map(value => value.unwrap))(_.intervalUnit)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.RetentionArchiveTier.ReadOnly =
    zio.aws.dlm.model.RetentionArchiveTier.wrap(buildAwsValue())
}
object RetentionArchiveTier {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.RetentionArchiveTier
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.RetentionArchiveTier =
      zio.aws.dlm.model.RetentionArchiveTier(
        count.map(value => value),
        interval.map(value => value),
        intervalUnit.map(value => value)
      )
    def count: Optional[Count]
    def interval: Optional[Interval]
    def intervalUnit: Optional[zio.aws.dlm.model.RetentionIntervalUnitValues]
    def getCount: ZIO[Any, AwsError, Count] =
      AwsError.unwrapOptionField("count", count)
    def getInterval: ZIO[Any, AwsError, Interval] =
      AwsError.unwrapOptionField("interval", interval)
    def getIntervalUnit
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetentionIntervalUnitValues] =
      AwsError.unwrapOptionField("intervalUnit", intervalUnit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.RetentionArchiveTier
  ) extends zio.aws.dlm.model.RetentionArchiveTier.ReadOnly {
    override val count: Optional[Count] = zio.aws.core.internal
      .optionalFromNullable(impl.count())
      .map(value => zio.aws.dlm.model.primitives.Count(value))
    override val interval: Optional[Interval] = zio.aws.core.internal
      .optionalFromNullable(impl.interval())
      .map(value => zio.aws.dlm.model.primitives.Interval(value))
    override val intervalUnit
        : Optional[zio.aws.dlm.model.RetentionIntervalUnitValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.intervalUnit())
        .map(value => zio.aws.dlm.model.RetentionIntervalUnitValues.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.RetentionArchiveTier
  ): zio.aws.dlm.model.RetentionArchiveTier.ReadOnly = new Wrapper(impl)
}
