package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait RetentionIntervalUnitValues {
  def unwrap
      : software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues
}
object RetentionIntervalUnitValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues
  ): zio.aws.dlm.model.RetentionIntervalUnitValues = value match {
    case software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.DAYS =>
      val r = DAYS
      r
    case software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.WEEKS =>
      val r = WEEKS
      r
    case software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.MONTHS =>
      val r = MONTHS
      r
    case software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.YEARS =>
      val r = YEARS
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dlm.model.RetentionIntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.UNKNOWN_TO_SDK_VERSION
  }
  case object DAYS extends zio.aws.dlm.model.RetentionIntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.DAYS
  }
  case object WEEKS extends zio.aws.dlm.model.RetentionIntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.WEEKS
  }
  case object MONTHS extends zio.aws.dlm.model.RetentionIntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.MONTHS
  }
  case object YEARS extends zio.aws.dlm.model.RetentionIntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.RetentionIntervalUnitValues.YEARS
  }
}
