package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait SettablePolicyStateValues {
  def unwrap
      : software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues
}
object SettablePolicyStateValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues
  ): zio.aws.dlm.model.SettablePolicyStateValues = value match {
    case software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.dlm.model.SettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.dlm.model.SettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues.ENABLED
  }
  case object DISABLED extends zio.aws.dlm.model.SettablePolicyStateValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues =
      software.amazon.awssdk.services.dlm.model.SettablePolicyStateValues.DISABLED
  }
}
