package zio.aws.dlm
import zio.prelude.Subtype
import zio.aws.dlm.model.primitives.{
  Time,
  TagFilter,
  TagValue,
  AvailabilityZone,
  PolicyId,
  AwsAccountId,
  TagKey
}
import java.time.Instant
import zio.aws.dlm.model.primitives.Time.Type
package object model {
  import scala.jdk.CollectionConverters.*
  object primitives {
    object ActionName extends Subtype[String]
    type ActionName = zio.aws.dlm.model.primitives.ActionName.Type
    object AvailabilityZone extends Subtype[String]
    type AvailabilityZone = zio.aws.dlm.model.primitives.AvailabilityZone.Type
    object AwsAccountId extends Subtype[String]
    type AwsAccountId = zio.aws.dlm.model.primitives.AwsAccountId.Type
    object CmkArn extends Subtype[String]
    type CmkArn = zio.aws.dlm.model.primitives.CmkArn.Type
    object CopyTags extends Subtype[Boolean]
    type CopyTags = zio.aws.dlm.model.primitives.CopyTags.Type
    object CopyTagsNullable extends Subtype[Boolean]
    type CopyTagsNullable = zio.aws.dlm.model.primitives.CopyTagsNullable.Type
    object Count extends Subtype[Int]
    type Count = zio.aws.dlm.model.primitives.Count.Type
    object CronExpression extends Subtype[String]
    type CronExpression = zio.aws.dlm.model.primitives.CronExpression.Type
    object DescriptionRegex extends Subtype[String]
    type DescriptionRegex = zio.aws.dlm.model.primitives.DescriptionRegex.Type
    object Encrypted extends Subtype[Boolean]
    type Encrypted = zio.aws.dlm.model.primitives.Encrypted.Type
    object ExcludeBootVolume extends Subtype[Boolean]
    type ExcludeBootVolume = zio.aws.dlm.model.primitives.ExcludeBootVolume.Type
    object ExecutionRoleArn extends Subtype[String]
    type ExecutionRoleArn = zio.aws.dlm.model.primitives.ExecutionRoleArn.Type
    object Interval extends Subtype[Int]
    type Interval = zio.aws.dlm.model.primitives.Interval.Type
    object NoReboot extends Subtype[Boolean]
    type NoReboot = zio.aws.dlm.model.primitives.NoReboot.Type
    object PolicyArn extends Subtype[String]
    type PolicyArn = zio.aws.dlm.model.primitives.PolicyArn.Type
    object PolicyDescription extends Subtype[String]
    type PolicyDescription = zio.aws.dlm.model.primitives.PolicyDescription.Type
    object PolicyId extends Subtype[String]
    type PolicyId = zio.aws.dlm.model.primitives.PolicyId.Type
    object ScheduleName extends Subtype[String]
    type ScheduleName = zio.aws.dlm.model.primitives.ScheduleName.Type
    object StandardTierRetainRuleCount extends Subtype[Int]
    type StandardTierRetainRuleCount =
      zio.aws.dlm.model.primitives.StandardTierRetainRuleCount.Type
    object StandardTierRetainRuleInterval extends Subtype[Int]
    type StandardTierRetainRuleInterval =
      zio.aws.dlm.model.primitives.StandardTierRetainRuleInterval.Type
    object StatusMessage extends Subtype[String]
    type StatusMessage = zio.aws.dlm.model.primitives.StatusMessage.Type
    object TagFilter extends Subtype[String]
    type TagFilter = zio.aws.dlm.model.primitives.TagFilter.Type
    object TagKey extends Subtype[String]
    type TagKey = zio.aws.dlm.model.primitives.TagKey.Type
    object TagValue extends Subtype[String]
    type TagValue = zio.aws.dlm.model.primitives.TagValue.Type
    object Target extends Subtype[String]
    type Target = zio.aws.dlm.model.primitives.Target.Type
    object TargetRegion extends Subtype[String]
    type TargetRegion = zio.aws.dlm.model.primitives.TargetRegion.Type
    object Time extends Subtype[String]
    type Time = zio.aws.dlm.model.primitives.Time.Type
    object Timestamp extends Subtype[Instant]
    type Timestamp = zio.aws.dlm.model.primitives.Timestamp.Type
  }
  type ActionList = List[zio.aws.dlm.model.Action]
  type AvailabilityZoneList = List[AvailabilityZone]
  type CrossRegionCopyActionList = List[zio.aws.dlm.model.CrossRegionCopyAction]
  type CrossRegionCopyRules = List[zio.aws.dlm.model.CrossRegionCopyRule]
  type ExcludeDataVolumeTagList = List[zio.aws.dlm.model.Tag]
  type LifecyclePolicySummaryList =
    List[zio.aws.dlm.model.LifecyclePolicySummary]
  type PolicyIdList = List[PolicyId]
  type ResourceLocationList = List[zio.aws.dlm.model.ResourceLocationValues]
  type ResourceTypeValuesList = List[zio.aws.dlm.model.ResourceTypeValues]
  type ScheduleList = List[zio.aws.dlm.model.Schedule]
  type ShareRules = List[zio.aws.dlm.model.ShareRule]
  type ShareTargetAccountList = List[AwsAccountId]
  type SnapshotOwnerList = List[AwsAccountId]
  type TagKeyList = List[TagKey]
  type TagMap = Map[TagKey, TagValue]
  type TagsToAddFilterList = List[TagFilter]
  type TagsToAddList = List[zio.aws.dlm.model.Tag]
  type TargetTagList = List[zio.aws.dlm.model.Tag]
  type TargetTagsFilterList = List[TagFilter]
  type TimesList = List[Time]
  type VariableTagsList = List[zio.aws.dlm.model.Tag]
}
