package zio.aws.dlm
import zio.aws.dlm.model.TagResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import software.amazon.awssdk.services.dlm.DlmAsyncClient
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.dlm.model.{
  GetLifecyclePoliciesRequest,
  ListTagsForResourceRequest,
  CreateLifecyclePolicyRequest,
  DeleteLifecyclePolicyRequest,
  UntagResourceRequest,
  GetLifecyclePolicyRequest,
  TagResourceRequest,
  UpdateLifecyclePolicyRequest
}
object DlmMock extends Mock[Dlm] {
  object DeleteLifecyclePolicy
      extends Effect[
        DeleteLifecyclePolicyRequest,
        AwsError,
        zio.aws.dlm.model.DeleteLifecyclePolicyResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.dlm.model.UntagResourceResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.dlm.model.ListTagsForResourceResponse.ReadOnly
      ]
  object TagResource extends Effect[TagResourceRequest, AwsError, ReadOnly]
  object CreateLifecyclePolicy
      extends Effect[
        CreateLifecyclePolicyRequest,
        AwsError,
        zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly
      ]
  object GetLifecyclePolicies
      extends Effect[
        GetLifecyclePoliciesRequest,
        AwsError,
        zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly
      ]
  object GetLifecyclePolicy
      extends Effect[
        GetLifecyclePolicyRequest,
        AwsError,
        zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly
      ]
  object UpdateLifecyclePolicy
      extends Effect[
        UpdateLifecyclePolicyRequest,
        AwsError,
        zio.aws.dlm.model.UpdateLifecyclePolicyResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Dlm] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Dlm] { rts =>
        zio.ZIO.succeed {
          new Dlm {
            val api: DlmAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Dlm = this
            def deleteLifecyclePolicy(
                request: DeleteLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.dlm.model.DeleteLifecyclePolicyResponse.ReadOnly
            ] = proxy(DeleteLifecyclePolicy, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.dlm.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.dlm.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(TagResource, request)
            def createLifecyclePolicy(
                request: CreateLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.dlm.model.CreateLifecyclePolicyResponse.ReadOnly
            ] = proxy(CreateLifecyclePolicy, request)
            def getLifecyclePolicies(request: GetLifecyclePoliciesRequest): IO[
              AwsError,
              zio.aws.dlm.model.GetLifecyclePoliciesResponse.ReadOnly
            ] = proxy(GetLifecyclePolicies, request)
            def getLifecyclePolicy(request: GetLifecyclePolicyRequest): IO[
              AwsError,
              zio.aws.dlm.model.GetLifecyclePolicyResponse.ReadOnly
            ] = proxy(GetLifecyclePolicy, request)
            def updateLifecyclePolicy(
                request: UpdateLifecyclePolicyRequest
            ): IO[
              AwsError,
              zio.aws.dlm.model.UpdateLifecyclePolicyResponse.ReadOnly
            ] = proxy(UpdateLifecyclePolicy, request)
          }
        }
      }
    }
  }
}
