package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ArchiveRetainRule(
    retentionArchiveTier: zio.aws.dlm.model.RetentionArchiveTier
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.ArchiveRetainRule = {
    import ArchiveRetainRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.ArchiveRetainRule
      .builder()
      .retentionArchiveTier(retentionArchiveTier.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.ArchiveRetainRule.ReadOnly =
    zio.aws.dlm.model.ArchiveRetainRule.wrap(buildAwsValue())
}
object ArchiveRetainRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.ArchiveRetainRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.ArchiveRetainRule =
      zio.aws.dlm.model.ArchiveRetainRule(retentionArchiveTier.asEditable)
    def retentionArchiveTier: zio.aws.dlm.model.RetentionArchiveTier.ReadOnly
    def getRetentionArchiveTier
        : ZIO[Any, Nothing, zio.aws.dlm.model.RetentionArchiveTier.ReadOnly] =
      ZIO.succeed(retentionArchiveTier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.ArchiveRetainRule
  ) extends zio.aws.dlm.model.ArchiveRetainRule.ReadOnly {
    override val retentionArchiveTier
        : zio.aws.dlm.model.RetentionArchiveTier.ReadOnly =
      zio.aws.dlm.model.RetentionArchiveTier.wrap(impl.retentionArchiveTier())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.ArchiveRetainRule
  ): zio.aws.dlm.model.ArchiveRetainRule.ReadOnly = new Wrapper(impl)
}
