package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{
  CmkArn,
  Encrypted,
  TargetRegion,
  CopyTagsNullable,
  Target
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CrossRegionCopyRule(
    targetRegion: Optional[TargetRegion] = Optional.Absent,
    target: Optional[Target] = Optional.Absent,
    encrypted: Encrypted,
    cmkArn: Optional[CmkArn] = Optional.Absent,
    copyTags: Optional[CopyTagsNullable] = Optional.Absent,
    retainRule: Optional[zio.aws.dlm.model.CrossRegionCopyRetainRule] =
      Optional.Absent,
    deprecateRule: Optional[zio.aws.dlm.model.CrossRegionCopyDeprecateRule] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.CrossRegionCopyRule = {
    import CrossRegionCopyRule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.CrossRegionCopyRule
      .builder()
      .optionallyWith(
        targetRegion.map(value => TargetRegion.unwrap(value): java.lang.String)
      )(_.targetRegion)
      .optionallyWith(
        target.map(value => Target.unwrap(value): java.lang.String)
      )(_.target)
      .encrypted(Encrypted.unwrap(encrypted): java.lang.Boolean)
      .optionallyWith(
        cmkArn.map(value => CmkArn.unwrap(value): java.lang.String)
      )(_.cmkArn)
      .optionallyWith(
        copyTags.map(value => CopyTagsNullable.unwrap(value): java.lang.Boolean)
      )(_.copyTags)
      .optionallyWith(retainRule.map(value => value.buildAwsValue()))(
        _.retainRule
      )
      .optionallyWith(deprecateRule.map(value => value.buildAwsValue()))(
        _.deprecateRule
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.CrossRegionCopyRule.ReadOnly =
    zio.aws.dlm.model.CrossRegionCopyRule.wrap(buildAwsValue())
}
object CrossRegionCopyRule {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.CrossRegionCopyRule
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.CrossRegionCopyRule =
      zio.aws.dlm.model.CrossRegionCopyRule(
        targetRegion.map(value => value),
        target.map(value => value),
        encrypted,
        cmkArn.map(value => value),
        copyTags.map(value => value),
        retainRule.map(value => value.asEditable),
        deprecateRule.map(value => value.asEditable)
      )
    def targetRegion: Optional[TargetRegion]
    def target: Optional[Target]
    def encrypted: Encrypted
    def cmkArn: Optional[CmkArn]
    def copyTags: Optional[CopyTagsNullable]
    def retainRule
        : Optional[zio.aws.dlm.model.CrossRegionCopyRetainRule.ReadOnly]
    def deprecateRule
        : Optional[zio.aws.dlm.model.CrossRegionCopyDeprecateRule.ReadOnly]
    def getTargetRegion: ZIO[Any, AwsError, TargetRegion] =
      AwsError.unwrapOptionField("targetRegion", targetRegion)
    def getTarget: ZIO[Any, AwsError, Target] =
      AwsError.unwrapOptionField("target", target)
    def getEncrypted: ZIO[Any, Nothing, Encrypted] = ZIO.succeed(encrypted)
    def getCmkArn: ZIO[Any, AwsError, CmkArn] =
      AwsError.unwrapOptionField("cmkArn", cmkArn)
    def getCopyTags: ZIO[Any, AwsError, CopyTagsNullable] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getRetainRule: ZIO[
      Any,
      AwsError,
      zio.aws.dlm.model.CrossRegionCopyRetainRule.ReadOnly
    ] = AwsError.unwrapOptionField("retainRule", retainRule)
    def getDeprecateRule: ZIO[
      Any,
      AwsError,
      zio.aws.dlm.model.CrossRegionCopyDeprecateRule.ReadOnly
    ] = AwsError.unwrapOptionField("deprecateRule", deprecateRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.CrossRegionCopyRule
  ) extends zio.aws.dlm.model.CrossRegionCopyRule.ReadOnly {
    override val targetRegion: Optional[TargetRegion] = zio.aws.core.internal
      .optionalFromNullable(impl.targetRegion())
      .map(value => zio.aws.dlm.model.primitives.TargetRegion(value))
    override val target: Optional[Target] = zio.aws.core.internal
      .optionalFromNullable(impl.target())
      .map(value => zio.aws.dlm.model.primitives.Target(value))
    override val encrypted: Encrypted =
      zio.aws.dlm.model.primitives.Encrypted(impl.encrypted())
    override val cmkArn: Optional[CmkArn] = zio.aws.core.internal
      .optionalFromNullable(impl.cmkArn())
      .map(value => zio.aws.dlm.model.primitives.CmkArn(value))
    override val copyTags: Optional[CopyTagsNullable] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => zio.aws.dlm.model.primitives.CopyTagsNullable(value))
    override val retainRule
        : Optional[zio.aws.dlm.model.CrossRegionCopyRetainRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainRule())
        .map(value => zio.aws.dlm.model.CrossRegionCopyRetainRule.wrap(value))
    override val deprecateRule
        : Optional[zio.aws.dlm.model.CrossRegionCopyDeprecateRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecateRule())
        .map(value =>
          zio.aws.dlm.model.CrossRegionCopyDeprecateRule.wrap(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.CrossRegionCopyRule
  ): zio.aws.dlm.model.CrossRegionCopyRule.ReadOnly = new Wrapper(impl)
}
