package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.PolicyId
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteLifecyclePolicyRequest(policyId: PolicyId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.DeleteLifecyclePolicyRequest = {
    import DeleteLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.DeleteLifecyclePolicyRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.DeleteLifecyclePolicyRequest.ReadOnly =
    zio.aws.dlm.model.DeleteLifecyclePolicyRequest.wrap(buildAwsValue())
}
object DeleteLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.DeleteLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.DeleteLifecyclePolicyRequest =
      zio.aws.dlm.model.DeleteLifecyclePolicyRequest(policyId)
    def policyId: PolicyId
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.DeleteLifecyclePolicyRequest
  ) extends zio.aws.dlm.model.DeleteLifecyclePolicyRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.dlm.model.primitives.PolicyId(impl.policyId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.DeleteLifecyclePolicyRequest
  ): zio.aws.dlm.model.DeleteLifecyclePolicyRequest.ReadOnly = new Wrapper(impl)
}
