package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{CmkArn, Encrypted}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EncryptionConfiguration(
    encrypted: Encrypted,
    cmkArn: Optional[CmkArn] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.EncryptionConfiguration = {
    import EncryptionConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.EncryptionConfiguration
      .builder()
      .encrypted(Encrypted.unwrap(encrypted): java.lang.Boolean)
      .optionallyWith(
        cmkArn.map(value => CmkArn.unwrap(value): java.lang.String)
      )(_.cmkArn)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.EncryptionConfiguration.ReadOnly =
    zio.aws.dlm.model.EncryptionConfiguration.wrap(buildAwsValue())
}
object EncryptionConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.EncryptionConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.EncryptionConfiguration =
      zio.aws.dlm.model
        .EncryptionConfiguration(encrypted, cmkArn.map(value => value))
    def encrypted: Encrypted
    def cmkArn: Optional[CmkArn]
    def getEncrypted: ZIO[Any, Nothing, Encrypted] = ZIO.succeed(encrypted)
    def getCmkArn: ZIO[Any, AwsError, CmkArn] =
      AwsError.unwrapOptionField("cmkArn", cmkArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.EncryptionConfiguration
  ) extends zio.aws.dlm.model.EncryptionConfiguration.ReadOnly {
    override val encrypted: Encrypted =
      zio.aws.dlm.model.primitives.Encrypted(impl.encrypted())
    override val cmkArn: Optional[CmkArn] = zio.aws.core.internal
      .optionalFromNullable(impl.cmkArn())
      .map(value => zio.aws.dlm.model.primitives.CmkArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.EncryptionConfiguration
  ): zio.aws.dlm.model.EncryptionConfiguration.ReadOnly = new Wrapper(impl)
}
