package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EventSource(
    `type`: zio.aws.dlm.model.EventSourceValues,
    parameters: Optional[zio.aws.dlm.model.EventParameters] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.EventSource = {
    import EventSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.EventSource
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(parameters.map(value => value.buildAwsValue()))(
        _.parameters
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.EventSource.ReadOnly =
    zio.aws.dlm.model.EventSource.wrap(buildAwsValue())
}
object EventSource {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.EventSource] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.EventSource = zio.aws.dlm.model
      .EventSource(`type`, parameters.map(value => value.asEditable))
    def `type`: zio.aws.dlm.model.EventSourceValues
    def parameters: Optional[zio.aws.dlm.model.EventParameters.ReadOnly]
    def getType: ZIO[Any, Nothing, zio.aws.dlm.model.EventSourceValues] =
      ZIO.succeed(`type`)
    def getParameters
        : ZIO[Any, AwsError, zio.aws.dlm.model.EventParameters.ReadOnly] =
      AwsError.unwrapOptionField("parameters", parameters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.EventSource
  ) extends zio.aws.dlm.model.EventSource.ReadOnly {
    override val `type`: zio.aws.dlm.model.EventSourceValues =
      zio.aws.dlm.model.EventSourceValues.wrap(impl.`type`())
    override val parameters
        : Optional[zio.aws.dlm.model.EventParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value => zio.aws.dlm.model.EventParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.EventSource
  ): zio.aws.dlm.model.EventSource.ReadOnly = new Wrapper(impl)
}
