package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait IntervalUnitValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.IntervalUnitValues
}
object IntervalUnitValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.IntervalUnitValues
  ): zio.aws.dlm.model.IntervalUnitValues = value match {
    case software.amazon.awssdk.services.dlm.model.IntervalUnitValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.IntervalUnitValues.HOURS =>
      val r = HOURS
      r
  }
  case object unknownToSdkVersion extends zio.aws.dlm.model.IntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.IntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.IntervalUnitValues.UNKNOWN_TO_SDK_VERSION
  }
  case object HOURS extends zio.aws.dlm.model.IntervalUnitValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.IntervalUnitValues =
      software.amazon.awssdk.services.dlm.model.IntervalUnitValues.HOURS
  }
}
