package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.PolicyArn
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceRequest(resourceArn: PolicyArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.ListTagsForResourceRequest = {
    import ListTagsForResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.ListTagsForResourceRequest
      .builder()
      .resourceArn(PolicyArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.ListTagsForResourceRequest.ReadOnly =
    zio.aws.dlm.model.ListTagsForResourceRequest.wrap(buildAwsValue())
}
object ListTagsForResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.ListTagsForResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.ListTagsForResourceRequest =
      zio.aws.dlm.model.ListTagsForResourceRequest(resourceArn)
    def resourceArn: PolicyArn
    def getResourceArn: ZIO[Any, Nothing, PolicyArn] = ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.ListTagsForResourceRequest
  ) extends zio.aws.dlm.model.ListTagsForResourceRequest.ReadOnly {
    override val resourceArn: PolicyArn =
      zio.aws.dlm.model.primitives.PolicyArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.ListTagsForResourceRequest
  ): zio.aws.dlm.model.ListTagsForResourceRequest.ReadOnly = new Wrapper(impl)
}
