package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait LocationValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.LocationValues
}
object LocationValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.LocationValues
  ): zio.aws.dlm.model.LocationValues = value match {
    case software.amazon.awssdk.services.dlm.model.LocationValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.LocationValues.CLOUD =>
      val r = CLOUD
      r
    case software.amazon.awssdk.services.dlm.model.LocationValues.OUTPOST_LOCAL =>
      val r = OUTPOST_LOCAL
      r
  }
  case object unknownToSdkVersion extends zio.aws.dlm.model.LocationValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.LocationValues =
      software.amazon.awssdk.services.dlm.model.LocationValues.UNKNOWN_TO_SDK_VERSION
  }
  case object CLOUD extends zio.aws.dlm.model.LocationValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.LocationValues =
      software.amazon.awssdk.services.dlm.model.LocationValues.CLOUD
  }
  case object OUTPOST_LOCAL extends zio.aws.dlm.model.LocationValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.LocationValues =
      software.amazon.awssdk.services.dlm.model.LocationValues.OUTPOST_LOCAL
  }
}
