package zio.aws.dlm.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PolicyDetails(
    policyType: Optional[zio.aws.dlm.model.PolicyTypeValues] = Optional.Absent,
    resourceTypes: Optional[Iterable[zio.aws.dlm.model.ResourceTypeValues]] =
      Optional.Absent,
    resourceLocations: Optional[
      Iterable[zio.aws.dlm.model.ResourceLocationValues]
    ] = Optional.Absent,
    targetTags: Optional[Iterable[zio.aws.dlm.model.Tag]] = Optional.Absent,
    schedules: Optional[Iterable[zio.aws.dlm.model.Schedule]] = Optional.Absent,
    parameters: Optional[zio.aws.dlm.model.Parameters] = Optional.Absent,
    eventSource: Optional[zio.aws.dlm.model.EventSource] = Optional.Absent,
    actions: Optional[Iterable[zio.aws.dlm.model.Action]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.PolicyDetails = {
    import PolicyDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.PolicyDetails
      .builder()
      .optionallyWith(policyType.map(value => value.unwrap))(_.policyType)
      .optionallyWith(
        resourceTypes.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceTypesWithStrings)
      .optionallyWith(
        resourceLocations.map(value =>
          value.map { item =>
            item.unwrap.toString
          }.asJavaCollection
        )
      )(_.resourceLocationsWithStrings)
      .optionallyWith(
        targetTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.targetTags)
      .optionallyWith(
        schedules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.schedules)
      .optionallyWith(parameters.map(value => value.buildAwsValue()))(
        _.parameters
      )
      .optionallyWith(eventSource.map(value => value.buildAwsValue()))(
        _.eventSource
      )
      .optionallyWith(
        actions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.actions)
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.PolicyDetails.ReadOnly =
    zio.aws.dlm.model.PolicyDetails.wrap(buildAwsValue())
}
object PolicyDetails {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.PolicyDetails] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.PolicyDetails =
      zio.aws.dlm.model.PolicyDetails(
        policyType.map(value => value),
        resourceTypes.map(value => value),
        resourceLocations.map(value => value),
        targetTags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        schedules.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        parameters.map(value => value.asEditable),
        eventSource.map(value => value.asEditable),
        actions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def policyType: Optional[zio.aws.dlm.model.PolicyTypeValues]
    def resourceTypes: Optional[List[zio.aws.dlm.model.ResourceTypeValues]]
    def resourceLocations
        : Optional[List[zio.aws.dlm.model.ResourceLocationValues]]
    def targetTags: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]]
    def schedules: Optional[List[zio.aws.dlm.model.Schedule.ReadOnly]]
    def parameters: Optional[zio.aws.dlm.model.Parameters.ReadOnly]
    def eventSource: Optional[zio.aws.dlm.model.EventSource.ReadOnly]
    def actions: Optional[List[zio.aws.dlm.model.Action.ReadOnly]]
    def getPolicyType: ZIO[Any, AwsError, zio.aws.dlm.model.PolicyTypeValues] =
      AwsError.unwrapOptionField("policyType", policyType)
    def getResourceTypes
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.ResourceTypeValues]] =
      AwsError.unwrapOptionField("resourceTypes", resourceTypes)
    def getResourceLocations
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.ResourceLocationValues]] =
      AwsError.unwrapOptionField("resourceLocations", resourceLocations)
    def getTargetTags
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("targetTags", targetTags)
    def getSchedules
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.Schedule.ReadOnly]] =
      AwsError.unwrapOptionField("schedules", schedules)
    def getParameters
        : ZIO[Any, AwsError, zio.aws.dlm.model.Parameters.ReadOnly] =
      AwsError.unwrapOptionField("parameters", parameters)
    def getEventSource
        : ZIO[Any, AwsError, zio.aws.dlm.model.EventSource.ReadOnly] =
      AwsError.unwrapOptionField("eventSource", eventSource)
    def getActions
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.Action.ReadOnly]] =
      AwsError.unwrapOptionField("actions", actions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.PolicyDetails
  ) extends zio.aws.dlm.model.PolicyDetails.ReadOnly {
    override val policyType: Optional[zio.aws.dlm.model.PolicyTypeValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyType())
        .map(value => zio.aws.dlm.model.PolicyTypeValues.wrap(value))
    override val resourceTypes
        : Optional[List[zio.aws.dlm.model.ResourceTypeValues]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceTypes())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.ResourceTypeValues.wrap(item)
          }.toList
        )
    override val resourceLocations
        : Optional[List[zio.aws.dlm.model.ResourceLocationValues]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceLocations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.ResourceLocationValues.wrap(item)
          }.toList
        )
    override val targetTags: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.targetTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.Tag.wrap(item)
          }.toList
        )
    override val schedules
        : Optional[List[zio.aws.dlm.model.Schedule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.schedules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.Schedule.wrap(item)
          }.toList
        )
    override val parameters: Optional[zio.aws.dlm.model.Parameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.parameters())
        .map(value => zio.aws.dlm.model.Parameters.wrap(value))
    override val eventSource: Optional[zio.aws.dlm.model.EventSource.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventSource())
        .map(value => zio.aws.dlm.model.EventSource.wrap(value))
    override val actions: Optional[List[zio.aws.dlm.model.Action.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actions())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.Action.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.PolicyDetails
  ): zio.aws.dlm.model.PolicyDetails.ReadOnly = new Wrapper(impl)
}
