package zio.aws.dlm.model
import scala.jdk.CollectionConverters.*
sealed trait PolicyTypeValues {
  def unwrap: software.amazon.awssdk.services.dlm.model.PolicyTypeValues
}
object PolicyTypeValues {
  def wrap(
      value: software.amazon.awssdk.services.dlm.model.PolicyTypeValues
  ): zio.aws.dlm.model.PolicyTypeValues = value match {
    case software.amazon.awssdk.services.dlm.model.PolicyTypeValues.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.dlm.model.PolicyTypeValues.EBS_SNAPSHOT_MANAGEMENT =>
      val r = EBS_SNAPSHOT_MANAGEMENT
      r
    case software.amazon.awssdk.services.dlm.model.PolicyTypeValues.IMAGE_MANAGEMENT =>
      val r = IMAGE_MANAGEMENT
      r
    case software.amazon.awssdk.services.dlm.model.PolicyTypeValues.EVENT_BASED_POLICY =>
      val r = EVENT_BASED_POLICY
      r
  }
  case object unknownToSdkVersion extends zio.aws.dlm.model.PolicyTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.PolicyTypeValues =
      software.amazon.awssdk.services.dlm.model.PolicyTypeValues.UNKNOWN_TO_SDK_VERSION
  }
  case object EBS_SNAPSHOT_MANAGEMENT
      extends zio.aws.dlm.model.PolicyTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.PolicyTypeValues =
      software.amazon.awssdk.services.dlm.model.PolicyTypeValues.EBS_SNAPSHOT_MANAGEMENT
  }
  case object IMAGE_MANAGEMENT extends zio.aws.dlm.model.PolicyTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.PolicyTypeValues =
      software.amazon.awssdk.services.dlm.model.PolicyTypeValues.IMAGE_MANAGEMENT
  }
  case object EVENT_BASED_POLICY extends zio.aws.dlm.model.PolicyTypeValues {
    override def unwrap
        : software.amazon.awssdk.services.dlm.model.PolicyTypeValues =
      software.amazon.awssdk.services.dlm.model.PolicyTypeValues.EVENT_BASED_POLICY
  }
}
