package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{CopyTags, ScheduleName}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class Schedule(
    name: Optional[ScheduleName] = Optional.Absent,
    copyTags: Optional[CopyTags] = Optional.Absent,
    tagsToAdd: Optional[Iterable[zio.aws.dlm.model.Tag]] = Optional.Absent,
    variableTags: Optional[Iterable[zio.aws.dlm.model.Tag]] = Optional.Absent,
    createRule: Optional[zio.aws.dlm.model.CreateRule] = Optional.Absent,
    retainRule: Optional[zio.aws.dlm.model.RetainRule] = Optional.Absent,
    fastRestoreRule: Optional[zio.aws.dlm.model.FastRestoreRule] =
      Optional.Absent,
    crossRegionCopyRules: Optional[
      Iterable[zio.aws.dlm.model.CrossRegionCopyRule]
    ] = Optional.Absent,
    shareRules: Optional[Iterable[zio.aws.dlm.model.ShareRule]] =
      Optional.Absent,
    deprecateRule: Optional[zio.aws.dlm.model.DeprecateRule] = Optional.Absent,
    archiveRule: Optional[zio.aws.dlm.model.ArchiveRule] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.dlm.model.Schedule = {
    import Schedule.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.Schedule
      .builder()
      .optionallyWith(
        name.map(value => ScheduleName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        copyTags.map(value => CopyTags.unwrap(value): java.lang.Boolean)
      )(_.copyTags)
      .optionallyWith(
        tagsToAdd.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagsToAdd)
      .optionallyWith(
        variableTags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.variableTags)
      .optionallyWith(createRule.map(value => value.buildAwsValue()))(
        _.createRule
      )
      .optionallyWith(retainRule.map(value => value.buildAwsValue()))(
        _.retainRule
      )
      .optionallyWith(fastRestoreRule.map(value => value.buildAwsValue()))(
        _.fastRestoreRule
      )
      .optionallyWith(
        crossRegionCopyRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.crossRegionCopyRules)
      .optionallyWith(
        shareRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.shareRules)
      .optionallyWith(deprecateRule.map(value => value.buildAwsValue()))(
        _.deprecateRule
      )
      .optionallyWith(archiveRule.map(value => value.buildAwsValue()))(
        _.archiveRule
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.Schedule.ReadOnly =
    zio.aws.dlm.model.Schedule.wrap(buildAwsValue())
}
object Schedule {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.dlm.model.Schedule] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.Schedule = zio.aws.dlm.model.Schedule(
      name.map(value => value),
      copyTags.map(value => value),
      tagsToAdd.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      variableTags.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      createRule.map(value => value.asEditable),
      retainRule.map(value => value.asEditable),
      fastRestoreRule.map(value => value.asEditable),
      crossRegionCopyRules.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      shareRules.map(value =>
        value.map { item =>
          item.asEditable
        }
      ),
      deprecateRule.map(value => value.asEditable),
      archiveRule.map(value => value.asEditable)
    )
    def name: Optional[ScheduleName]
    def copyTags: Optional[CopyTags]
    def tagsToAdd: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]]
    def variableTags: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]]
    def createRule: Optional[zio.aws.dlm.model.CreateRule.ReadOnly]
    def retainRule: Optional[zio.aws.dlm.model.RetainRule.ReadOnly]
    def fastRestoreRule: Optional[zio.aws.dlm.model.FastRestoreRule.ReadOnly]
    def crossRegionCopyRules
        : Optional[List[zio.aws.dlm.model.CrossRegionCopyRule.ReadOnly]]
    def shareRules: Optional[List[zio.aws.dlm.model.ShareRule.ReadOnly]]
    def deprecateRule: Optional[zio.aws.dlm.model.DeprecateRule.ReadOnly]
    def archiveRule: Optional[zio.aws.dlm.model.ArchiveRule.ReadOnly]
    def getName: ZIO[Any, AwsError, ScheduleName] =
      AwsError.unwrapOptionField("name", name)
    def getCopyTags: ZIO[Any, AwsError, CopyTags] =
      AwsError.unwrapOptionField("copyTags", copyTags)
    def getTagsToAdd: ZIO[Any, AwsError, List[zio.aws.dlm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tagsToAdd", tagsToAdd)
    def getVariableTags
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("variableTags", variableTags)
    def getCreateRule
        : ZIO[Any, AwsError, zio.aws.dlm.model.CreateRule.ReadOnly] =
      AwsError.unwrapOptionField("createRule", createRule)
    def getRetainRule
        : ZIO[Any, AwsError, zio.aws.dlm.model.RetainRule.ReadOnly] =
      AwsError.unwrapOptionField("retainRule", retainRule)
    def getFastRestoreRule
        : ZIO[Any, AwsError, zio.aws.dlm.model.FastRestoreRule.ReadOnly] =
      AwsError.unwrapOptionField("fastRestoreRule", fastRestoreRule)
    def getCrossRegionCopyRules: ZIO[Any, AwsError, List[
      zio.aws.dlm.model.CrossRegionCopyRule.ReadOnly
    ]] =
      AwsError.unwrapOptionField("crossRegionCopyRules", crossRegionCopyRules)
    def getShareRules
        : ZIO[Any, AwsError, List[zio.aws.dlm.model.ShareRule.ReadOnly]] =
      AwsError.unwrapOptionField("shareRules", shareRules)
    def getDeprecateRule
        : ZIO[Any, AwsError, zio.aws.dlm.model.DeprecateRule.ReadOnly] =
      AwsError.unwrapOptionField("deprecateRule", deprecateRule)
    def getArchiveRule
        : ZIO[Any, AwsError, zio.aws.dlm.model.ArchiveRule.ReadOnly] =
      AwsError.unwrapOptionField("archiveRule", archiveRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.Schedule
  ) extends zio.aws.dlm.model.Schedule.ReadOnly {
    override val name: Optional[ScheduleName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.dlm.model.primitives.ScheduleName(value))
    override val copyTags: Optional[CopyTags] = zio.aws.core.internal
      .optionalFromNullable(impl.copyTags())
      .map(value => zio.aws.dlm.model.primitives.CopyTags(value))
    override val tagsToAdd: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tagsToAdd())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.Tag.wrap(item)
          }.toList
        )
    override val variableTags: Optional[List[zio.aws.dlm.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.variableTags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.Tag.wrap(item)
          }.toList
        )
    override val createRule: Optional[zio.aws.dlm.model.CreateRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.createRule())
        .map(value => zio.aws.dlm.model.CreateRule.wrap(value))
    override val retainRule: Optional[zio.aws.dlm.model.RetainRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.retainRule())
        .map(value => zio.aws.dlm.model.RetainRule.wrap(value))
    override val fastRestoreRule
        : Optional[zio.aws.dlm.model.FastRestoreRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fastRestoreRule())
        .map(value => zio.aws.dlm.model.FastRestoreRule.wrap(value))
    override val crossRegionCopyRules
        : Optional[List[zio.aws.dlm.model.CrossRegionCopyRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.crossRegionCopyRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.CrossRegionCopyRule.wrap(item)
          }.toList
        )
    override val shareRules
        : Optional[List[zio.aws.dlm.model.ShareRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.shareRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.dlm.model.ShareRule.wrap(item)
          }.toList
        )
    override val deprecateRule
        : Optional[zio.aws.dlm.model.DeprecateRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deprecateRule())
        .map(value => zio.aws.dlm.model.DeprecateRule.wrap(value))
    override val archiveRule: Optional[zio.aws.dlm.model.ArchiveRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.archiveRule())
        .map(value => zio.aws.dlm.model.ArchiveRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.Schedule
  ): zio.aws.dlm.model.Schedule.ReadOnly = new Wrapper(impl)
}
