package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{TagValue, TagKey, PolicyArn}
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceArn: PolicyArn,
    tags: Map[TagKey, TagValue]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.TagResourceRequest
      .builder()
      .resourceArn(PolicyArn.unwrap(resourceArn): java.lang.String)
      .tags(
        tags
          .map({ case (key, value) =>
            (TagKey.unwrap(key): java.lang.String) -> (TagValue
              .unwrap(value): java.lang.String)
          })
          .asJava
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.TagResourceRequest.ReadOnly =
    zio.aws.dlm.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.TagResourceRequest =
      zio.aws.dlm.model.TagResourceRequest(resourceArn, tags)
    def resourceArn: PolicyArn
    def tags: Map[TagKey, TagValue]
    def getResourceArn: ZIO[Any, Nothing, PolicyArn] = ZIO.succeed(resourceArn)
    def getTags: ZIO[Any, Nothing, Map[TagKey, TagValue]] = ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.TagResourceRequest
  ) extends zio.aws.dlm.model.TagResourceRequest.ReadOnly {
    override val resourceArn: PolicyArn =
      zio.aws.dlm.model.primitives.PolicyArn(impl.resourceArn())
    override val tags: Map[TagKey, TagValue] = impl
      .tags()
      .asScala
      .map({ case (key, value) =>
        zio.aws.dlm.model.primitives.TagKey(key) -> zio.aws.dlm.model.primitives
          .TagValue(value)
      })
      .toMap
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.TagResourceRequest
  ): zio.aws.dlm.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
