package zio.aws.dlm.model
import zio.ZIO
import zio.aws.dlm.model.primitives.{
  PolicyDescription,
  ExecutionRoleArn,
  PolicyId
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateLifecyclePolicyRequest(
    policyId: PolicyId,
    executionRoleArn: Optional[ExecutionRoleArn] = Optional.Absent,
    state: Optional[zio.aws.dlm.model.SettablePolicyStateValues] =
      Optional.Absent,
    description: Optional[PolicyDescription] = Optional.Absent,
    policyDetails: Optional[zio.aws.dlm.model.PolicyDetails] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.dlm.model.UpdateLifecyclePolicyRequest = {
    import UpdateLifecyclePolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.dlm.model.UpdateLifecyclePolicyRequest
      .builder()
      .policyId(PolicyId.unwrap(policyId): java.lang.String)
      .optionallyWith(
        executionRoleArn.map(value =>
          ExecutionRoleArn.unwrap(value): java.lang.String
        )
      )(_.executionRoleArn)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(
        description.map(value =>
          PolicyDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(policyDetails.map(value => value.buildAwsValue()))(
        _.policyDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.dlm.model.UpdateLifecyclePolicyRequest.ReadOnly =
    zio.aws.dlm.model.UpdateLifecyclePolicyRequest.wrap(buildAwsValue())
}
object UpdateLifecyclePolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.dlm.model.UpdateLifecyclePolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.dlm.model.UpdateLifecyclePolicyRequest =
      zio.aws.dlm.model.UpdateLifecyclePolicyRequest(
        policyId,
        executionRoleArn.map(value => value),
        state.map(value => value),
        description.map(value => value),
        policyDetails.map(value => value.asEditable)
      )
    def policyId: PolicyId
    def executionRoleArn: Optional[ExecutionRoleArn]
    def state: Optional[zio.aws.dlm.model.SettablePolicyStateValues]
    def description: Optional[PolicyDescription]
    def policyDetails: Optional[zio.aws.dlm.model.PolicyDetails.ReadOnly]
    def getPolicyId: ZIO[Any, Nothing, PolicyId] = ZIO.succeed(policyId)
    def getExecutionRoleArn: ZIO[Any, AwsError, ExecutionRoleArn] =
      AwsError.unwrapOptionField("executionRoleArn", executionRoleArn)
    def getState
        : ZIO[Any, AwsError, zio.aws.dlm.model.SettablePolicyStateValues] =
      AwsError.unwrapOptionField("state", state)
    def getDescription: ZIO[Any, AwsError, PolicyDescription] =
      AwsError.unwrapOptionField("description", description)
    def getPolicyDetails
        : ZIO[Any, AwsError, zio.aws.dlm.model.PolicyDetails.ReadOnly] =
      AwsError.unwrapOptionField("policyDetails", policyDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.dlm.model.UpdateLifecyclePolicyRequest
  ) extends zio.aws.dlm.model.UpdateLifecyclePolicyRequest.ReadOnly {
    override val policyId: PolicyId =
      zio.aws.dlm.model.primitives.PolicyId(impl.policyId())
    override val executionRoleArn: Optional[ExecutionRoleArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionRoleArn())
        .map(value => zio.aws.dlm.model.primitives.ExecutionRoleArn(value))
    override val state: Optional[zio.aws.dlm.model.SettablePolicyStateValues] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.dlm.model.SettablePolicyStateValues.wrap(value))
    override val description: Optional[PolicyDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value => zio.aws.dlm.model.primitives.PolicyDescription(value))
    override val policyDetails
        : Optional[zio.aws.dlm.model.PolicyDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.policyDetails())
        .map(value => zio.aws.dlm.model.PolicyDetails.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.dlm.model.UpdateLifecyclePolicyRequest
  ): zio.aws.dlm.model.UpdateLifecyclePolicyRequest.ReadOnly = new Wrapper(impl)
}
