package zio.aws.docdb
import zio.aws.docdb.model.CreateEventSubscriptionResponse.ReadOnly
import zio.aws.docdb.model.{
  DescribeEventCategoriesRequest,
  DescribeDbClusterSnapshotsRequest,
  ModifyEventSubscriptionRequest,
  DeleteDbSubnetGroupRequest,
  ModifyDbClusterSnapshotAttributeRequest,
  ModifyGlobalClusterRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  DeleteDbClusterRequest,
  RestoreDbClusterFromSnapshotRequest,
  DeleteGlobalClusterRequest,
  CopyDbClusterSnapshotRequest,
  DeleteDbClusterSnapshotRequest,
  DescribeEventsRequest,
  DescribeDbInstancesRequest,
  ApplyPendingMaintenanceActionRequest,
  DescribeDbEngineVersionsRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  ModifyDbClusterParameterGroupRequest,
  DescribeDbClusterSnapshotAttributesRequest,
  StartDbClusterRequest,
  DescribeDbClustersRequest,
  CreateGlobalClusterRequest,
  CreateDbSubnetGroupRequest,
  FailoverDbClusterRequest,
  CreateDbClusterRequest,
  ModifyDbClusterRequest,
  RemoveFromGlobalClusterRequest,
  ModifyDbInstanceRequest,
  DescribeDbClusterParametersRequest,
  RemoveTagsFromResourceRequest,
  DescribeCertificatesRequest,
  DescribePendingMaintenanceActionsRequest,
  ModifyDbSubnetGroupRequest,
  DescribeDbClusterParameterGroupsRequest,
  CopyDbClusterParameterGroupRequest,
  StopDbClusterRequest,
  DeleteDbClusterParameterGroupRequest,
  RemoveSourceIdentifierFromSubscriptionRequest,
  RestoreDbClusterToPointInTimeRequest,
  DeleteDbInstanceRequest,
  CreateDbInstanceRequest,
  DescribeDbSubnetGroupsRequest,
  DescribeEngineDefaultClusterParametersRequest,
  ResetDbClusterParameterGroupRequest,
  RebootDbInstanceRequest,
  DescribeOrderableDbInstanceOptionsRequest,
  DescribeGlobalClustersRequest,
  DescribeEventSubscriptionsRequest,
  AddSourceIdentifierToSubscriptionRequest,
  CreateDbClusterParameterGroupRequest,
  CreateDbClusterSnapshotRequest
}
import zio.aws.core.config.AwsConfig
import software.amazon.awssdk.services.docdb.{
  DocDbAsyncClientBuilder,
  DocDbAsyncClient
}
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.stream.ZStream
import software.amazon.awssdk.services.docdb.model.{
  DeleteDbInstanceResponse,
  StopDbClusterResponse,
  DescribeEventsResponse,
  DescribeEngineDefaultClusterParametersResponse,
  EventSubscription,
  DBClusterParameterGroup,
  Certificate,
  DescribeDbClusterSnapshotsResponse,
  RemoveFromGlobalClusterResponse,
  DescribeDbClustersResponse,
  DBCluster,
  DescribeDbInstancesResponse,
  CreateDbSubnetGroupResponse,
  DescribeEventCategoriesResponse,
  RemoveTagsFromResourceResponse,
  DBClusterSnapshot,
  DescribeDbClusterSnapshotAttributesResponse,
  ModifyDbClusterSnapshotAttributeResponse,
  OrderableDBInstanceOption,
  ResetDbClusterParameterGroupResponse,
  ModifyEventSubscriptionResponse,
  AddSourceIdentifierToSubscriptionResponse,
  DescribeDbClusterParametersResponse,
  DBEngineVersion,
  CreateDbClusterParameterGroupResponse,
  ModifyGlobalClusterResponse,
  DescribePendingMaintenanceActionsResponse,
  DeleteDbClusterSnapshotResponse,
  GlobalCluster,
  CopyDbClusterSnapshotResponse,
  RestoreDbClusterFromSnapshotResponse,
  RebootDbInstanceResponse,
  ModifyDbClusterParameterGroupResponse,
  CreateDbInstanceResponse,
  CreateDbClusterResponse,
  DeleteGlobalClusterResponse,
  ModifyDbInstanceResponse,
  ApplyPendingMaintenanceActionResponse,
  ResourcePendingMaintenanceActions,
  ListTagsForResourceResponse,
  DescribeCertificatesResponse,
  DescribeEventSubscriptionsResponse,
  DescribeOrderableDbInstanceOptionsResponse,
  DeleteDbClusterParameterGroupResponse,
  CreateEventSubscriptionResponse,
  RemoveSourceIdentifierFromSubscriptionResponse,
  FailoverDbClusterResponse,
  DeleteDbClusterResponse,
  DescribeDbClusterParameterGroupsResponse,
  CreateDbClusterSnapshotResponse,
  CreateGlobalClusterResponse,
  DBSubnetGroup,
  AddTagsToResourceResponse,
  ModifyDbClusterResponse,
  StartDbClusterResponse,
  Event,
  CopyDbClusterParameterGroupResponse,
  ModifyDbSubnetGroupResponse,
  RestoreDbClusterToPointInTimeResponse,
  Parameter,
  DeleteDbSubnetGroupResponse,
  DeleteEventSubscriptionResponse,
  DescribeGlobalClustersResponse,
  DBInstance,
  DescribeDbEngineVersionsResponse,
  DescribeDbSubnetGroupsResponse
}
import software.amazon.awssdk.services.docdb.paginators.{
  DescribeCertificatesPublisher,
  DescribePendingMaintenanceActionsPublisher,
  DescribeOrderableDBInstanceOptionsPublisher,
  DescribeDBClusterSnapshotsPublisher,
  DescribeDBInstancesPublisher,
  DescribeEventSubscriptionsPublisher,
  DescribeDBClusterParametersPublisher,
  DescribeDBClustersPublisher,
  DescribeDBSubnetGroupsPublisher,
  DescribeDBEngineVersionsPublisher,
  DescribeGlobalClustersPublisher,
  DescribeEventsPublisher,
  DescribeDBClusterParameterGroupsPublisher
}
import scala.jdk.CollectionConverters.*
trait DocDb extends AspectSupport[DocDb] {
  val api: DocDbAsyncClient
  def copyDBClusterSnapshot(
      request: CopyDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly]
  def modifyDBInstance(
      request: ModifyDbInstanceRequest
  ): IO[AwsError, zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly]
  def addTagsToResource(request: AddTagsToResourceRequest): IO[AwsError, Unit]
  def describeDBClusterSnapshots(
      request: DescribeDbClusterSnapshotsRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.DBClusterSnapshot.ReadOnly]
  def describeDBClusterSnapshotsPaginated(
      request: DescribeDbClusterSnapshotsRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly
  ]
  def resetDBClusterParameterGroup(
      request: ResetDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly
  ]
  def removeSourceIdentifierFromSubscription(
      request: RemoveSourceIdentifierFromSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
  ]
  def describeEngineDefaultClusterParameters(
      request: DescribeEngineDefaultClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
  ]
  def createDBSubnetGroup(
      request: CreateDbSubnetGroupRequest
  ): IO[AwsError, zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly]
  def copyDBClusterParameterGroup(
      request: CopyDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly
  ]
  def describePendingMaintenanceActions(
      request: DescribePendingMaintenanceActionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
  ]
  def describePendingMaintenanceActionsPaginated(
      request: DescribePendingMaintenanceActionsRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ]
  def deleteDBClusterParameterGroup(
      request: DeleteDbClusterParameterGroupRequest
  ): IO[AwsError, Unit]
  def removeFromGlobalCluster(
      request: RemoveFromGlobalClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.RemoveFromGlobalClusterResponse.ReadOnly]
  def modifyDBClusterParameterGroup(
      request: ModifyDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly
  ]
  def stopDBCluster(
      request: StopDbClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.StopDbClusterResponse.ReadOnly]
  def createDBCluster(
      request: CreateDbClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly]
  def describeCertificates(
      request: DescribeCertificatesRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.Certificate.ReadOnly]
  def describeCertificatesPaginated(
      request: DescribeCertificatesRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeCertificatesResponse.ReadOnly]
  def deleteEventSubscription(
      request: DeleteEventSubscriptionRequest
  ): IO[AwsError, zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly]
  def describeDBSubnetGroups(
      request: DescribeDbSubnetGroupsRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.DBSubnetGroup.ReadOnly]
  def describeDBSubnetGroupsPaginated(
      request: DescribeDbSubnetGroupsRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly]
  def createDBClusterParameterGroup(
      request: CreateDbClusterParameterGroupRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.CreateDbClusterParameterGroupResponse.ReadOnly
  ]
  def modifyDBCluster(
      request: ModifyDbClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly]
  def removeTagsFromResource(
      request: RemoveTagsFromResourceRequest
  ): IO[AwsError, Unit]
  def applyPendingMaintenanceAction(
      request: ApplyPendingMaintenanceActionRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ]
  def modifyDBSubnetGroup(
      request: ModifyDbSubnetGroupRequest
  ): IO[AwsError, zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly]
  def modifyGlobalCluster(
      request: ModifyGlobalClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.ModifyGlobalClusterResponse.ReadOnly]
  def restoreDBClusterFromSnapshot(
      request: RestoreDbClusterFromSnapshotRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
  ]
  def describeGlobalClusters(
      request: DescribeGlobalClustersRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.GlobalCluster.ReadOnly]
  def describeGlobalClustersPaginated(
      request: DescribeGlobalClustersRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeGlobalClustersResponse.ReadOnly]
  def describeDBClusterParameters(
      request: DescribeDbClusterParametersRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.Parameter.ReadOnly]
  def describeDBClusterParametersPaginated(
      request: DescribeDbClusterParametersRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly
  ]
  def modifyEventSubscription(
      request: ModifyEventSubscriptionRequest
  ): IO[AwsError, zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly]
  def createDBInstance(
      request: CreateDbInstanceRequest
  ): IO[AwsError, zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly]
  def deleteDBClusterSnapshot(
      request: DeleteDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly]
  def startDBCluster(
      request: StartDbClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.StartDbClusterResponse.ReadOnly]
  def modifyDBClusterSnapshotAttribute(
      request: ModifyDbClusterSnapshotAttributeRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
  ]
  def describeEventCategories(
      request: DescribeEventCategoriesRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly]
  def deleteDBSubnetGroup(
      request: DeleteDbSubnetGroupRequest
  ): IO[AwsError, Unit]
  def rebootDBInstance(
      request: RebootDbInstanceRequest
  ): IO[AwsError, zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly]
  def describeDBClusterParameterGroups(
      request: DescribeDbClusterParameterGroupsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
  ]
  def describeDBClusterParameterGroupsPaginated(
      request: DescribeDbClusterParameterGroupsRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
  ]
  def createEventSubscription(
      request: CreateEventSubscriptionRequest
  ): IO[AwsError, ReadOnly]
  def listTagsForResource(
      request: ListTagsForResourceRequest
  ): IO[AwsError, zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly]
  def restoreDBClusterToPointInTime(
      request: RestoreDbClusterToPointInTimeRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
  ]
  def describeDBClusters(
      request: DescribeDbClustersRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly]
  def describeDBClustersPaginated(
      request: DescribeDbClustersRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeDbClustersResponse.ReadOnly]
  def failoverDBCluster(
      request: FailoverDbClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly]
  def describeEventSubscriptions(
      request: DescribeEventSubscriptionsRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.EventSubscription.ReadOnly]
  def describeEventSubscriptionsPaginated(
      request: DescribeEventSubscriptionsRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeEventSubscriptionsResponse.ReadOnly
  ]
  def describeDBInstances(
      request: DescribeDbInstancesRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.DBInstance.ReadOnly]
  def describeDBInstancesPaginated(
      request: DescribeDbInstancesRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly]
  def createDBClusterSnapshot(
      request: CreateDbClusterSnapshotRequest
  ): IO[AwsError, zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly]
  def deleteDBCluster(
      request: DeleteDbClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.DeleteDbClusterResponse.ReadOnly]
  def deleteGlobalCluster(
      request: DeleteGlobalClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly]
  def deleteDBInstance(
      request: DeleteDbInstanceRequest
  ): IO[AwsError, zio.aws.docdb.model.DeleteDbInstanceResponse.ReadOnly]
  def addSourceIdentifierToSubscription(
      request: AddSourceIdentifierToSubscriptionRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
  ]
  def describeDBEngineVersions(
      request: DescribeDbEngineVersionsRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.DBEngineVersion.ReadOnly]
  def describeDBEngineVersionsPaginated(
      request: DescribeDbEngineVersionsRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly]
  def createGlobalCluster(
      request: CreateGlobalClusterRequest
  ): IO[AwsError, zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly]
  def describeOrderableDBInstanceOptions(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly
  ]
  def describeOrderableDBInstanceOptionsPaginated(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
  ]
  def describeDBClusterSnapshotAttributes(
      request: DescribeDbClusterSnapshotAttributesRequest
  ): IO[
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
  ]
  def describeEvents(
      request: DescribeEventsRequest
  ): ZStream[Any, AwsError, zio.aws.docdb.model.Event.ReadOnly]
  def describeEventsPaginated(
      request: DescribeEventsRequest
  ): IO[AwsError, zio.aws.docdb.model.DescribeEventsResponse.ReadOnly]
}
object DocDb {
  val live: ZLayer[AwsConfig, java.lang.Throwable, DocDb] = customized(identity)
  def customized(
      customization: DocDbAsyncClientBuilder => DocDbAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, DocDb] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: DocDbAsyncClientBuilder => DocDbAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, DocDb] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = DocDbAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[DocDbAsyncClient, DocDbAsyncClientBuilder](
      builder
    );
    b1 <- awsConfig
      .configureHttpClient[DocDbAsyncClient, DocDbAsyncClientBuilder](
        b0,
        zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
      ); client <- ZIO.attempt(customization(b1).build())
  ) yield new DocDbImpl(client, AwsCallAspect.identity, ZEnvironment.empty)
  private class DocDbImpl[R](
      override val api: DocDbAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends DocDb
      with AwsServiceBase[R] {
    override val serviceName: String = "DocDb"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): DocDbImpl[R1] = new DocDbImpl(api, newAspect, r)
    def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.CopyDbClusterSnapshotRequest,
      CopyDbClusterSnapshotResponse
    ]("copyDBClusterSnapshot", api.copyDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.CopyDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def modifyDBInstance(
        request: ModifyDbInstanceRequest
    ): IO[AwsError, zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.ModifyDbInstanceRequest,
        ModifyDbInstanceResponse
      ]("modifyDBInstance", api.modifyDBInstance)(request.buildAwsValue())
        .map(zio.aws.docdb.model.ModifyDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def addTagsToResource(
        request: AddTagsToResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.AddTagsToResourceRequest,
      AddTagsToResourceResponse
    ]("addTagsToResource", api.addTagsToResource)(request.buildAwsValue()).unit
      .provideEnvironment(r)
    def describeDBClusterSnapshots(
        request: DescribeDbClusterSnapshotsRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.DBClusterSnapshot.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest,
        DBClusterSnapshot,
        DescribeDBClusterSnapshotsPublisher
      ](
        "describeDBClusterSnapshots",
        api.describeDBClusterSnapshotsPaginator,
        _.dbClusterSnapshots()
      )(request.buildAwsValue())
        .map(item => zio.aws.docdb.model.DBClusterSnapshot.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterSnapshotsPaginated(
        request: DescribeDbClusterSnapshotsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotsRequest,
      DescribeDbClusterSnapshotsResponse
    ]("describeDBClusterSnapshots", api.describeDBClusterSnapshots)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.wrap)
      .provideEnvironment(r)
    def resetDBClusterParameterGroup(
        request: ResetDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.ResetDbClusterParameterGroupRequest,
      ResetDbClusterParameterGroupResponse
    ]("resetDBClusterParameterGroup", api.resetDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def removeSourceIdentifierFromSubscription(
        request: RemoveSourceIdentifierFromSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.RemoveSourceIdentifierFromSubscriptionRequest,
      RemoveSourceIdentifierFromSubscriptionResponse
    ](
      "removeSourceIdentifierFromSubscription",
      api.removeSourceIdentifierFromSubscription
    )(request.buildAwsValue())
      .map(
        zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.wrap
      )
      .provideEnvironment(r)
    def describeEngineDefaultClusterParameters(
        request: DescribeEngineDefaultClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeEngineDefaultClusterParametersRequest,
      DescribeEngineDefaultClusterParametersResponse
    ](
      "describeEngineDefaultClusterParameters",
      api.describeEngineDefaultClusterParameters
    )(request.buildAwsValue())
      .map(
        zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.wrap
      )
      .provideEnvironment(r)
    def createDBSubnetGroup(
        request: CreateDbSubnetGroupRequest
    ): IO[AwsError, zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.CreateDbSubnetGroupRequest,
        CreateDbSubnetGroupResponse
      ]("createDBSubnetGroup", api.createDBSubnetGroup)(request.buildAwsValue())
        .map(zio.aws.docdb.model.CreateDbSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def copyDBClusterParameterGroup(
        request: CopyDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.CopyDbClusterParameterGroupRequest,
      CopyDbClusterParameterGroupResponse
    ]("copyDBClusterParameterGroup", api.copyDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def describePendingMaintenanceActions(
        request: DescribePendingMaintenanceActionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest,
      ResourcePendingMaintenanceActions,
      DescribePendingMaintenanceActionsPublisher
    ](
      "describePendingMaintenanceActions",
      api.describePendingMaintenanceActionsPaginator,
      _.pendingMaintenanceActions()
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.docdb.model.ResourcePendingMaintenanceActions.wrap(item)
      )
      .provideEnvironment(r)
    def describePendingMaintenanceActionsPaginated(
        request: DescribePendingMaintenanceActionsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribePendingMaintenanceActionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribePendingMaintenanceActionsRequest,
      DescribePendingMaintenanceActionsResponse
    ](
      "describePendingMaintenanceActions",
      api.describePendingMaintenanceActions
    )(request.buildAwsValue())
      .map(zio.aws.docdb.model.DescribePendingMaintenanceActionsResponse.wrap)
      .provideEnvironment(r)
    def deleteDBClusterParameterGroup(
        request: DeleteDbClusterParameterGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DeleteDbClusterParameterGroupRequest,
      DeleteDbClusterParameterGroupResponse
    ]("deleteDBClusterParameterGroup", api.deleteDBClusterParameterGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def removeFromGlobalCluster(request: RemoveFromGlobalClusterRequest): IO[
      AwsError,
      zio.aws.docdb.model.RemoveFromGlobalClusterResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.RemoveFromGlobalClusterRequest,
      RemoveFromGlobalClusterResponse
    ]("removeFromGlobalCluster", api.removeFromGlobalCluster)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.RemoveFromGlobalClusterResponse.wrap)
      .provideEnvironment(r)
    def modifyDBClusterParameterGroup(
        request: ModifyDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.ModifyDbClusterParameterGroupRequest,
      ModifyDbClusterParameterGroupResponse
    ]("modifyDBClusterParameterGroup", api.modifyDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def stopDBCluster(
        request: StopDbClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.StopDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.StopDbClusterRequest,
        StopDbClusterResponse
      ]("stopDBCluster", api.stopDBCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.StopDbClusterResponse.wrap)
        .provideEnvironment(r)
    def createDBCluster(
        request: CreateDbClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.CreateDbClusterRequest,
        CreateDbClusterResponse
      ]("createDBCluster", api.createDBCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.CreateDbClusterResponse.wrap)
        .provideEnvironment(r)
    def describeCertificates(
        request: DescribeCertificatesRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.Certificate.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest,
        Certificate,
        DescribeCertificatesPublisher
      ](
        "describeCertificates",
        api.describeCertificatesPaginator,
        _.certificates()
      )(request.buildAwsValue())
        .map(item => zio.aws.docdb.model.Certificate.wrap(item))
        .provideEnvironment(r)
    def describeCertificatesPaginated(
        request: DescribeCertificatesRequest
    ): IO[AwsError, zio.aws.docdb.model.DescribeCertificatesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DescribeCertificatesRequest,
        DescribeCertificatesResponse
      ]("describeCertificates", api.describeCertificates)(
        request.buildAwsValue()
      ).map(zio.aws.docdb.model.DescribeCertificatesResponse.wrap)
        .provideEnvironment(r)
    def deleteEventSubscription(request: DeleteEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DeleteEventSubscriptionRequest,
      DeleteEventSubscriptionResponse
    ]("deleteEventSubscription", api.deleteEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DeleteEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeDBSubnetGroups(request: DescribeDbSubnetGroupsRequest): ZStream[
      Any,
      AwsError,
      zio.aws.docdb.model.DBSubnetGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest,
      DBSubnetGroup,
      DescribeDBSubnetGroupsPublisher
    ](
      "describeDBSubnetGroups",
      api.describeDBSubnetGroupsPaginator,
      _.dbSubnetGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.docdb.model.DBSubnetGroup.wrap(item))
      .provideEnvironment(r)
    def describeDBSubnetGroupsPaginated(
        request: DescribeDbSubnetGroupsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeDbSubnetGroupsRequest,
      DescribeDbSubnetGroupsResponse
    ]("describeDBSubnetGroups", api.describeDBSubnetGroups)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.wrap)
      .provideEnvironment(r)
    def createDBClusterParameterGroup(
        request: CreateDbClusterParameterGroupRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.CreateDbClusterParameterGroupResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.CreateDbClusterParameterGroupRequest,
      CreateDbClusterParameterGroupResponse
    ]("createDBClusterParameterGroup", api.createDBClusterParameterGroup)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.CreateDbClusterParameterGroupResponse.wrap)
      .provideEnvironment(r)
    def modifyDBCluster(
        request: ModifyDbClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.ModifyDbClusterRequest,
        ModifyDbClusterResponse
      ]("modifyDBCluster", api.modifyDBCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.ModifyDbClusterResponse.wrap)
        .provideEnvironment(r)
    def removeTagsFromResource(
        request: RemoveTagsFromResourceRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.RemoveTagsFromResourceRequest,
      RemoveTagsFromResourceResponse
    ]("removeTagsFromResource", api.removeTagsFromResource)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def applyPendingMaintenanceAction(
        request: ApplyPendingMaintenanceActionRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.ApplyPendingMaintenanceActionRequest,
      ApplyPendingMaintenanceActionResponse
    ]("applyPendingMaintenanceAction", api.applyPendingMaintenanceAction)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.wrap)
      .provideEnvironment(r)
    def modifyDBSubnetGroup(
        request: ModifyDbSubnetGroupRequest
    ): IO[AwsError, zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.ModifyDbSubnetGroupRequest,
        ModifyDbSubnetGroupResponse
      ]("modifyDBSubnetGroup", api.modifyDBSubnetGroup)(request.buildAwsValue())
        .map(zio.aws.docdb.model.ModifyDbSubnetGroupResponse.wrap)
        .provideEnvironment(r)
    def modifyGlobalCluster(
        request: ModifyGlobalClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.ModifyGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.ModifyGlobalClusterRequest,
        ModifyGlobalClusterResponse
      ]("modifyGlobalCluster", api.modifyGlobalCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.ModifyGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def restoreDBClusterFromSnapshot(
        request: RestoreDbClusterFromSnapshotRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.RestoreDbClusterFromSnapshotRequest,
      RestoreDbClusterFromSnapshotResponse
    ]("restoreDBClusterFromSnapshot", api.restoreDBClusterFromSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.wrap)
      .provideEnvironment(r)
    def describeGlobalClusters(request: DescribeGlobalClustersRequest): ZStream[
      Any,
      AwsError,
      zio.aws.docdb.model.GlobalCluster.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest,
      GlobalCluster,
      DescribeGlobalClustersPublisher
    ](
      "describeGlobalClusters",
      api.describeGlobalClustersPaginator,
      _.globalClusters()
    )(request.buildAwsValue())
      .map(item => zio.aws.docdb.model.GlobalCluster.wrap(item))
      .provideEnvironment(r)
    def describeGlobalClustersPaginated(
        request: DescribeGlobalClustersRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeGlobalClustersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeGlobalClustersRequest,
      DescribeGlobalClustersResponse
    ]("describeGlobalClusters", api.describeGlobalClusters)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeGlobalClustersResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusterParameters(
        request: DescribeDbClusterParametersRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.Parameter.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest,
        Parameter,
        DescribeDBClusterParametersPublisher
      ](
        "describeDBClusterParameters",
        api.describeDBClusterParametersPaginator,
        _.parameters()
      )(request.buildAwsValue())
        .map(item => zio.aws.docdb.model.Parameter.wrap(item))
        .provideEnvironment(r)
    def describeDBClusterParametersPaginated(
        request: DescribeDbClusterParametersRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeDbClusterParametersRequest,
      DescribeDbClusterParametersResponse
    ]("describeDBClusterParameters", api.describeDBClusterParameters)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeDbClusterParametersResponse.wrap)
      .provideEnvironment(r)
    def modifyEventSubscription(request: ModifyEventSubscriptionRequest): IO[
      AwsError,
      zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.ModifyEventSubscriptionRequest,
      ModifyEventSubscriptionResponse
    ]("modifyEventSubscription", api.modifyEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.ModifyEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def createDBInstance(
        request: CreateDbInstanceRequest
    ): IO[AwsError, zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.CreateDbInstanceRequest,
        CreateDbInstanceResponse
      ]("createDBInstance", api.createDBInstance)(request.buildAwsValue())
        .map(zio.aws.docdb.model.CreateDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DeleteDbClusterSnapshotRequest,
      DeleteDbClusterSnapshotResponse
    ]("deleteDBClusterSnapshot", api.deleteDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def startDBCluster(
        request: StartDbClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.StartDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.StartDbClusterRequest,
        StartDbClusterResponse
      ]("startDBCluster", api.startDBCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.StartDbClusterResponse.wrap)
        .provideEnvironment(r)
    def modifyDBClusterSnapshotAttribute(
        request: ModifyDbClusterSnapshotAttributeRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.ModifyDbClusterSnapshotAttributeRequest,
      ModifyDbClusterSnapshotAttributeResponse
    ]("modifyDBClusterSnapshotAttribute", api.modifyDBClusterSnapshotAttribute)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.wrap)
      .provideEnvironment(r)
    def describeEventCategories(request: DescribeEventCategoriesRequest): IO[
      AwsError,
      zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeEventCategoriesRequest,
      DescribeEventCategoriesResponse
    ]("describeEventCategories", api.describeEventCategories)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeEventCategoriesResponse.wrap)
      .provideEnvironment(r)
    def deleteDBSubnetGroup(
        request: DeleteDbSubnetGroupRequest
    ): IO[AwsError, Unit] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DeleteDbSubnetGroupRequest,
      DeleteDbSubnetGroupResponse
    ]("deleteDBSubnetGroup", api.deleteDBSubnetGroup)(
      request.buildAwsValue()
    ).unit.provideEnvironment(r)
    def rebootDBInstance(
        request: RebootDbInstanceRequest
    ): IO[AwsError, zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.RebootDbInstanceRequest,
        RebootDbInstanceResponse
      ]("rebootDBInstance", api.rebootDBInstance)(request.buildAwsValue())
        .map(zio.aws.docdb.model.RebootDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def describeDBClusterParameterGroups(
        request: DescribeDbClusterParameterGroupsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest,
      DBClusterParameterGroup,
      DescribeDBClusterParameterGroupsPublisher
    ](
      "describeDBClusterParameterGroups",
      api.describeDBClusterParameterGroupsPaginator,
      _.dbClusterParameterGroups()
    )(request.buildAwsValue())
      .map(item => zio.aws.docdb.model.DBClusterParameterGroup.wrap(item))
      .provideEnvironment(r)
    def describeDBClusterParameterGroupsPaginated(
        request: DescribeDbClusterParameterGroupsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeDbClusterParameterGroupsRequest,
      DescribeDbClusterParameterGroupsResponse
    ]("describeDBClusterParameterGroups", api.describeDBClusterParameterGroups)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.wrap)
      .provideEnvironment(r)
    def createEventSubscription(
        request: CreateEventSubscriptionRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.CreateEventSubscriptionRequest,
      CreateEventSubscriptionResponse
    ]("createEventSubscription", api.createEventSubscription)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.CreateEventSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def listTagsForResource(
        request: ListTagsForResourceRequest
    ): IO[AwsError, zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.ListTagsForResourceRequest,
        ListTagsForResourceResponse
      ]("listTagsForResource", api.listTagsForResource)(request.buildAwsValue())
        .map(zio.aws.docdb.model.ListTagsForResourceResponse.wrap)
        .provideEnvironment(r)
    def restoreDBClusterToPointInTime(
        request: RestoreDbClusterToPointInTimeRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.RestoreDbClusterToPointInTimeRequest,
      RestoreDbClusterToPointInTimeResponse
    ]("restoreDBClusterToPointInTime", api.restoreDBClusterToPointInTime)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusters(
        request: DescribeDbClustersRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest,
        DBCluster,
        DescribeDBClustersPublisher
      ]("describeDBClusters", api.describeDBClustersPaginator, _.dbClusters())(
        request.buildAwsValue()
      ).map(item => zio.aws.docdb.model.DBCluster.wrap(item))
        .provideEnvironment(r)
    def describeDBClustersPaginated(
        request: DescribeDbClustersRequest
    ): IO[AwsError, zio.aws.docdb.model.DescribeDbClustersResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DescribeDbClustersRequest,
        DescribeDbClustersResponse
      ]("describeDBClusters", api.describeDBClusters)(request.buildAwsValue())
        .map(zio.aws.docdb.model.DescribeDbClustersResponse.wrap)
        .provideEnvironment(r)
    def failoverDBCluster(
        request: FailoverDbClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.FailoverDbClusterRequest,
        FailoverDbClusterResponse
      ]("failoverDBCluster", api.failoverDBCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.FailoverDbClusterResponse.wrap)
        .provideEnvironment(r)
    def describeEventSubscriptions(
        request: DescribeEventSubscriptionsRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.EventSubscription.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsRequest,
        EventSubscription,
        DescribeEventSubscriptionsPublisher
      ](
        "describeEventSubscriptions",
        api.describeEventSubscriptionsPaginator,
        _.eventSubscriptionsList()
      )(request.buildAwsValue())
        .map(item => zio.aws.docdb.model.EventSubscription.wrap(item))
        .provideEnvironment(r)
    def describeEventSubscriptionsPaginated(
        request: DescribeEventSubscriptionsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeEventSubscriptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeEventSubscriptionsRequest,
      DescribeEventSubscriptionsResponse
    ]("describeEventSubscriptions", api.describeEventSubscriptions)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeEventSubscriptionsResponse.wrap)
      .provideEnvironment(r)
    def describeDBInstances(
        request: DescribeDbInstancesRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.DBInstance.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest,
        DBInstance,
        DescribeDBInstancesPublisher
      ](
        "describeDBInstances",
        api.describeDBInstancesPaginator,
        _.dbInstances()
      )(request.buildAwsValue())
        .map(item => zio.aws.docdb.model.DBInstance.wrap(item))
        .provideEnvironment(r)
    def describeDBInstancesPaginated(
        request: DescribeDbInstancesRequest
    ): IO[AwsError, zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DescribeDbInstancesRequest,
        DescribeDbInstancesResponse
      ]("describeDBInstances", api.describeDBInstances)(request.buildAwsValue())
        .map(zio.aws.docdb.model.DescribeDbInstancesResponse.wrap)
        .provideEnvironment(r)
    def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): IO[
      AwsError,
      zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.CreateDbClusterSnapshotRequest,
      CreateDbClusterSnapshotResponse
    ]("createDBClusterSnapshot", api.createDBClusterSnapshot)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.CreateDbClusterSnapshotResponse.wrap)
      .provideEnvironment(r)
    def deleteDBCluster(
        request: DeleteDbClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.DeleteDbClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DeleteDbClusterRequest,
        DeleteDbClusterResponse
      ]("deleteDBCluster", api.deleteDBCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.DeleteDbClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteGlobalCluster(
        request: DeleteGlobalClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DeleteGlobalClusterRequest,
        DeleteGlobalClusterResponse
      ]("deleteGlobalCluster", api.deleteGlobalCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.DeleteGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def deleteDBInstance(
        request: DeleteDbInstanceRequest
    ): IO[AwsError, zio.aws.docdb.model.DeleteDbInstanceResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DeleteDbInstanceRequest,
        DeleteDbInstanceResponse
      ]("deleteDBInstance", api.deleteDBInstance)(request.buildAwsValue())
        .map(zio.aws.docdb.model.DeleteDbInstanceResponse.wrap)
        .provideEnvironment(r)
    def addSourceIdentifierToSubscription(
        request: AddSourceIdentifierToSubscriptionRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest,
      AddSourceIdentifierToSubscriptionResponse
    ](
      "addSourceIdentifierToSubscription",
      api.addSourceIdentifierToSubscription
    )(request.buildAwsValue())
      .map(zio.aws.docdb.model.AddSourceIdentifierToSubscriptionResponse.wrap)
      .provideEnvironment(r)
    def describeDBEngineVersions(
        request: DescribeDbEngineVersionsRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.DBEngineVersion.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest,
        DBEngineVersion,
        DescribeDBEngineVersionsPublisher
      ](
        "describeDBEngineVersions",
        api.describeDBEngineVersionsPaginator,
        _.dbEngineVersions()
      )(request.buildAwsValue())
        .map(item => zio.aws.docdb.model.DBEngineVersion.wrap(item))
        .provideEnvironment(r)
    def describeDBEngineVersionsPaginated(
        request: DescribeDbEngineVersionsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeDbEngineVersionsRequest,
      DescribeDbEngineVersionsResponse
    ]("describeDBEngineVersions", api.describeDBEngineVersions)(
      request.buildAwsValue()
    ).map(zio.aws.docdb.model.DescribeDbEngineVersionsResponse.wrap)
      .provideEnvironment(r)
    def createGlobalCluster(
        request: CreateGlobalClusterRequest
    ): IO[AwsError, zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.CreateGlobalClusterRequest,
        CreateGlobalClusterResponse
      ]("createGlobalCluster", api.createGlobalCluster)(request.buildAwsValue())
        .map(zio.aws.docdb.model.CreateGlobalClusterResponse.wrap)
        .provideEnvironment(r)
    def describeOrderableDBInstanceOptions(
        request: DescribeOrderableDbInstanceOptionsRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly
    ] = asyncJavaPaginatedRequest[
      software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest,
      OrderableDBInstanceOption,
      DescribeOrderableDBInstanceOptionsPublisher
    ](
      "describeOrderableDBInstanceOptions",
      api.describeOrderableDBInstanceOptionsPaginator,
      _.orderableDBInstanceOptions()
    )(request.buildAwsValue())
      .map(item => zio.aws.docdb.model.OrderableDBInstanceOption.wrap(item))
      .provideEnvironment(r)
    def describeOrderableDBInstanceOptionsPaginated(
        request: DescribeOrderableDbInstanceOptionsRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeOrderableDbInstanceOptionsRequest,
      DescribeOrderableDbInstanceOptionsResponse
    ](
      "describeOrderableDBInstanceOptions",
      api.describeOrderableDBInstanceOptions
    )(request.buildAwsValue())
      .map(zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsResponse.wrap)
      .provideEnvironment(r)
    def describeDBClusterSnapshotAttributes(
        request: DescribeDbClusterSnapshotAttributesRequest
    ): IO[
      AwsError,
      zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.docdb.model.DescribeDbClusterSnapshotAttributesRequest,
      DescribeDbClusterSnapshotAttributesResponse
    ](
      "describeDBClusterSnapshotAttributes",
      api.describeDBClusterSnapshotAttributes
    )(request.buildAwsValue())
      .map(zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.wrap)
      .provideEnvironment(r)
    def describeEvents(
        request: DescribeEventsRequest
    ): ZStream[Any, AwsError, zio.aws.docdb.model.Event.ReadOnly] =
      asyncJavaPaginatedRequest[
        software.amazon.awssdk.services.docdb.model.DescribeEventsRequest,
        Event,
        DescribeEventsPublisher
      ]("describeEvents", api.describeEventsPaginator, _.events())(
        request.buildAwsValue()
      ).map(item => zio.aws.docdb.model.Event.wrap(item)).provideEnvironment(r)
    def describeEventsPaginated(
        request: DescribeEventsRequest
    ): IO[AwsError, zio.aws.docdb.model.DescribeEventsResponse.ReadOnly] =
      asyncRequestResponse[
        software.amazon.awssdk.services.docdb.model.DescribeEventsRequest,
        DescribeEventsResponse
      ]("describeEvents", api.describeEvents)(request.buildAwsValue())
        .map(zio.aws.docdb.model.DescribeEventsResponse.wrap)
        .provideEnvironment(r)
  }
  def copyDBClusterSnapshot(request: CopyDbClusterSnapshotRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBClusterSnapshot(request))
  def modifyDBInstance(request: ModifyDbInstanceRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBInstance(request))
  def addTagsToResource(
      request: AddTagsToResourceRequest
  ): ZIO[zio.aws.docdb.DocDb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.addTagsToResource(request))
  def describeDBClusterSnapshots(
      request: DescribeDbClusterSnapshotsRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DBClusterSnapshot.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterSnapshots(request))
  def describeDBClusterSnapshotsPaginated(
      request: DescribeDbClusterSnapshotsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterSnapshotsPaginated(request))
  def resetDBClusterParameterGroup(
      request: ResetDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.resetDBClusterParameterGroup(request))
  def removeSourceIdentifierFromSubscription(
      request: RemoveSourceIdentifierFromSubscriptionRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeSourceIdentifierFromSubscription(request))
  def describeEngineDefaultClusterParameters(
      request: DescribeEngineDefaultClusterParametersRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEngineDefaultClusterParameters(request))
  def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBSubnetGroup(request))
  def copyDBClusterParameterGroup(
      request: CopyDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.copyDBClusterParameterGroup(request))
  def describePendingMaintenanceActions(
      request: DescribePendingMaintenanceActionsRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
  ] = ZStream.serviceWithStream(_.describePendingMaintenanceActions(request))
  def describePendingMaintenanceActionsPaginated(
      request: DescribePendingMaintenanceActionsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribePendingMaintenanceActionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describePendingMaintenanceActionsPaginated(request))
  def deleteDBClusterParameterGroup(
      request: DeleteDbClusterParameterGroupRequest
  ): ZIO[zio.aws.docdb.DocDb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBClusterParameterGroup(request))
  def removeFromGlobalCluster(request: RemoveFromGlobalClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.RemoveFromGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.removeFromGlobalCluster(request))
  def modifyDBClusterParameterGroup(
      request: ModifyDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterParameterGroup(request))
  def stopDBCluster(request: StopDbClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.StopDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.stopDBCluster(request))
  def createDBCluster(request: CreateDbClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBCluster(request))
  def describeCertificates(request: DescribeCertificatesRequest): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.Certificate.ReadOnly
  ] = ZStream.serviceWithStream(_.describeCertificates(request))
  def describeCertificatesPaginated(request: DescribeCertificatesRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeCertificatesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeCertificatesPaginated(request))
  def deleteEventSubscription(request: DeleteEventSubscriptionRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteEventSubscription(request))
  def describeDBSubnetGroups(request: DescribeDbSubnetGroupsRequest): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DBSubnetGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBSubnetGroups(request))
  def describeDBSubnetGroupsPaginated(
      request: DescribeDbSubnetGroupsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBSubnetGroupsPaginated(request))
  def createDBClusterParameterGroup(
      request: CreateDbClusterParameterGroupRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CreateDbClusterParameterGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterParameterGroup(request))
  def modifyDBCluster(request: ModifyDbClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBCluster(request))
  def removeTagsFromResource(
      request: RemoveTagsFromResourceRequest
  ): ZIO[zio.aws.docdb.DocDb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.removeTagsFromResource(request))
  def applyPendingMaintenanceAction(
      request: ApplyPendingMaintenanceActionRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.applyPendingMaintenanceAction(request))
  def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBSubnetGroup(request))
  def modifyGlobalCluster(request: ModifyGlobalClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyGlobalCluster(request))
  def restoreDBClusterFromSnapshot(
      request: RestoreDbClusterFromSnapshotRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterFromSnapshot(request))
  def describeGlobalClusters(request: DescribeGlobalClustersRequest): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.GlobalCluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeGlobalClusters(request))
  def describeGlobalClustersPaginated(
      request: DescribeGlobalClustersRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeGlobalClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeGlobalClustersPaginated(request))
  def describeDBClusterParameters(
      request: DescribeDbClusterParametersRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.Parameter.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterParameters(request))
  def describeDBClusterParametersPaginated(
      request: DescribeDbClusterParametersRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterParametersPaginated(request))
  def modifyEventSubscription(request: ModifyEventSubscriptionRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyEventSubscription(request))
  def createDBInstance(request: CreateDbInstanceRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBInstance(request))
  def deleteDBClusterSnapshot(request: DeleteDbClusterSnapshotRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBClusterSnapshot(request))
  def startDBCluster(request: StartDbClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.StartDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.startDBCluster(request))
  def modifyDBClusterSnapshotAttribute(
      request: ModifyDbClusterSnapshotAttributeRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.modifyDBClusterSnapshotAttribute(request))
  def describeEventCategories(request: DescribeEventCategoriesRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventCategories(request))
  def deleteDBSubnetGroup(
      request: DeleteDbSubnetGroupRequest
  ): ZIO[zio.aws.docdb.DocDb, AwsError, Unit] =
    ZIO.serviceWithZIO(_.deleteDBSubnetGroup(request))
  def rebootDBInstance(request: RebootDbInstanceRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.rebootDBInstance(request))
  def describeDBClusterParameterGroups(
      request: DescribeDbClusterParameterGroupsRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusterParameterGroups(request))
  def describeDBClusterParameterGroupsPaginated(
      request: DescribeDbClusterParameterGroupsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterParameterGroupsPaginated(request))
  def createEventSubscription(
      request: CreateEventSubscriptionRequest
  ): ZIO[zio.aws.docdb.DocDb, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.createEventSubscription(request))
  def listTagsForResource(request: ListTagsForResourceRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.listTagsForResource(request))
  def restoreDBClusterToPointInTime(
      request: RestoreDbClusterToPointInTimeRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.restoreDBClusterToPointInTime(request))
  def describeDBClusters(request: DescribeDbClustersRequest): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DBCluster.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBClusters(request))
  def describeDBClustersPaginated(request: DescribeDbClustersRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbClustersResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClustersPaginated(request))
  def failoverDBCluster(request: FailoverDbClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.failoverDBCluster(request))
  def describeEventSubscriptions(
      request: DescribeEventSubscriptionsRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.EventSubscription.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEventSubscriptions(request))
  def describeEventSubscriptionsPaginated(
      request: DescribeEventSubscriptionsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeEventSubscriptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventSubscriptionsPaginated(request))
  def describeDBInstances(request: DescribeDbInstancesRequest): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DBInstance.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBInstances(request))
  def describeDBInstancesPaginated(request: DescribeDbInstancesRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBInstancesPaginated(request))
  def createDBClusterSnapshot(request: CreateDbClusterSnapshotRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createDBClusterSnapshot(request))
  def deleteDBCluster(request: DeleteDbClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DeleteDbClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBCluster(request))
  def deleteGlobalCluster(request: DeleteGlobalClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteGlobalCluster(request))
  def deleteDBInstance(request: DeleteDbInstanceRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DeleteDbInstanceResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteDBInstance(request))
  def addSourceIdentifierToSubscription(
      request: AddSourceIdentifierToSubscriptionRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.addSourceIdentifierToSubscription(request))
  def describeDBEngineVersions(
      request: DescribeDbEngineVersionsRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DBEngineVersion.ReadOnly
  ] = ZStream.serviceWithStream(_.describeDBEngineVersions(request))
  def describeDBEngineVersionsPaginated(
      request: DescribeDbEngineVersionsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBEngineVersionsPaginated(request))
  def createGlobalCluster(request: CreateGlobalClusterRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createGlobalCluster(request))
  def describeOrderableDBInstanceOptions(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly
  ] = ZStream.serviceWithStream(_.describeOrderableDBInstanceOptions(request))
  def describeOrderableDBInstanceOptionsPaginated(
      request: DescribeOrderableDbInstanceOptionsRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeOrderableDBInstanceOptionsPaginated(request))
  def describeDBClusterSnapshotAttributes(
      request: DescribeDbClusterSnapshotAttributesRequest
  ): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeDBClusterSnapshotAttributes(request))
  def describeEvents(request: DescribeEventsRequest): ZStream[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.Event.ReadOnly
  ] = ZStream.serviceWithStream(_.describeEvents(request))
  def describeEventsPaginated(request: DescribeEventsRequest): ZIO[
    zio.aws.docdb.DocDb,
    AwsError,
    zio.aws.docdb.model.DescribeEventsResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeEventsPaginated(request))
}
