package zio.aws.docdb
import zio.aws.docdb.model.CreateEventSubscriptionResponse.ReadOnly
import zio.aws.docdb.model.{
  DescribeEventCategoriesRequest,
  DescribeDbClusterSnapshotsRequest,
  ModifyEventSubscriptionRequest,
  DeleteDbSubnetGroupRequest,
  ModifyDbClusterSnapshotAttributeRequest,
  ModifyGlobalClusterRequest,
  CreateEventSubscriptionRequest,
  AddTagsToResourceRequest,
  DeleteDbClusterRequest,
  RestoreDbClusterFromSnapshotRequest,
  DeleteGlobalClusterRequest,
  CopyDbClusterSnapshotRequest,
  DeleteDbClusterSnapshotRequest,
  DescribeEventsRequest,
  DescribeDbInstancesRequest,
  ApplyPendingMaintenanceActionRequest,
  DescribeDbEngineVersionsRequest,
  ListTagsForResourceRequest,
  DeleteEventSubscriptionRequest,
  ModifyDbClusterParameterGroupRequest,
  DescribeDbClusterSnapshotAttributesRequest,
  StartDbClusterRequest,
  DescribeDbClustersRequest,
  CreateGlobalClusterRequest,
  CreateDbSubnetGroupRequest,
  FailoverDbClusterRequest,
  CreateDbClusterRequest,
  ModifyDbClusterRequest,
  RemoveFromGlobalClusterRequest,
  ModifyDbInstanceRequest,
  DescribeDbClusterParametersRequest,
  RemoveTagsFromResourceRequest,
  DescribeCertificatesRequest,
  DescribePendingMaintenanceActionsRequest,
  ModifyDbSubnetGroupRequest,
  DescribeDbClusterParameterGroupsRequest,
  CopyDbClusterParameterGroupRequest,
  StopDbClusterRequest,
  DeleteDbClusterParameterGroupRequest,
  RemoveSourceIdentifierFromSubscriptionRequest,
  RestoreDbClusterToPointInTimeRequest,
  DeleteDbInstanceRequest,
  CreateDbInstanceRequest,
  DescribeDbSubnetGroupsRequest,
  DescribeEngineDefaultClusterParametersRequest,
  ResetDbClusterParameterGroupRequest,
  RebootDbInstanceRequest,
  DescribeOrderableDbInstanceOptionsRequest,
  DescribeGlobalClustersRequest,
  DescribeEventSubscriptionsRequest,
  AddSourceIdentifierToSubscriptionRequest,
  CreateDbClusterParameterGroupRequest,
  CreateDbClusterSnapshotRequest
}
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.docdb.DocDbAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.stream.ZStream
object DocDbMock extends Mock[DocDb] {
  object CopyDBClusterSnapshot
      extends Effect[
        CopyDbClusterSnapshotRequest,
        AwsError,
        zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly
      ]
  object ModifyDBInstance
      extends Effect[
        ModifyDbInstanceRequest,
        AwsError,
        zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly
      ]
  object AddTagsToResource
      extends Effect[AddTagsToResourceRequest, AwsError, Unit]
  object DescribeDBClusterSnapshots
      extends Stream[
        DescribeDbClusterSnapshotsRequest,
        AwsError,
        zio.aws.docdb.model.DBClusterSnapshot.ReadOnly
      ]
  object DescribeDBClusterSnapshotsPaginated
      extends Effect[
        DescribeDbClusterSnapshotsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly
      ]
  object ResetDBClusterParameterGroup
      extends Effect[
        ResetDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly
      ]
  object RemoveSourceIdentifierFromSubscription
      extends Effect[
        RemoveSourceIdentifierFromSubscriptionRequest,
        AwsError,
        zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
      ]
  object DescribeEngineDefaultClusterParameters
      extends Effect[
        DescribeEngineDefaultClusterParametersRequest,
        AwsError,
        zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
      ]
  object CreateDBSubnetGroup
      extends Effect[
        CreateDbSubnetGroupRequest,
        AwsError,
        zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly
      ]
  object CopyDBClusterParameterGroup
      extends Effect[
        CopyDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly
      ]
  object DescribePendingMaintenanceActions
      extends Stream[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
      ]
  object DescribePendingMaintenanceActionsPaginated
      extends Effect[
        DescribePendingMaintenanceActionsRequest,
        AwsError,
        zio.aws.docdb.model.DescribePendingMaintenanceActionsResponse.ReadOnly
      ]
  object DeleteDBClusterParameterGroup
      extends Effect[DeleteDbClusterParameterGroupRequest, AwsError, Unit]
  object RemoveFromGlobalCluster
      extends Effect[
        RemoveFromGlobalClusterRequest,
        AwsError,
        zio.aws.docdb.model.RemoveFromGlobalClusterResponse.ReadOnly
      ]
  object ModifyDBClusterParameterGroup
      extends Effect[
        ModifyDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly
      ]
  object StopDBCluster
      extends Effect[
        StopDbClusterRequest,
        AwsError,
        zio.aws.docdb.model.StopDbClusterResponse.ReadOnly
      ]
  object CreateDBCluster
      extends Effect[
        CreateDbClusterRequest,
        AwsError,
        zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly
      ]
  object DescribeCertificates
      extends Stream[
        DescribeCertificatesRequest,
        AwsError,
        zio.aws.docdb.model.Certificate.ReadOnly
      ]
  object DescribeCertificatesPaginated
      extends Effect[
        DescribeCertificatesRequest,
        AwsError,
        zio.aws.docdb.model.DescribeCertificatesResponse.ReadOnly
      ]
  object DeleteEventSubscription
      extends Effect[
        DeleteEventSubscriptionRequest,
        AwsError,
        zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly
      ]
  object DescribeDBSubnetGroups
      extends Stream[
        DescribeDbSubnetGroupsRequest,
        AwsError,
        zio.aws.docdb.model.DBSubnetGroup.ReadOnly
      ]
  object DescribeDBSubnetGroupsPaginated
      extends Effect[
        DescribeDbSubnetGroupsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly
      ]
  object CreateDBClusterParameterGroup
      extends Effect[
        CreateDbClusterParameterGroupRequest,
        AwsError,
        zio.aws.docdb.model.CreateDbClusterParameterGroupResponse.ReadOnly
      ]
  object ModifyDBCluster
      extends Effect[
        ModifyDbClusterRequest,
        AwsError,
        zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly
      ]
  object RemoveTagsFromResource
      extends Effect[RemoveTagsFromResourceRequest, AwsError, Unit]
  object ApplyPendingMaintenanceAction
      extends Effect[
        ApplyPendingMaintenanceActionRequest,
        AwsError,
        zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly
      ]
  object ModifyDBSubnetGroup
      extends Effect[
        ModifyDbSubnetGroupRequest,
        AwsError,
        zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly
      ]
  object ModifyGlobalCluster
      extends Effect[
        ModifyGlobalClusterRequest,
        AwsError,
        zio.aws.docdb.model.ModifyGlobalClusterResponse.ReadOnly
      ]
  object RestoreDBClusterFromSnapshot
      extends Effect[
        RestoreDbClusterFromSnapshotRequest,
        AwsError,
        zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
      ]
  object DescribeGlobalClusters
      extends Stream[
        DescribeGlobalClustersRequest,
        AwsError,
        zio.aws.docdb.model.GlobalCluster.ReadOnly
      ]
  object DescribeGlobalClustersPaginated
      extends Effect[
        DescribeGlobalClustersRequest,
        AwsError,
        zio.aws.docdb.model.DescribeGlobalClustersResponse.ReadOnly
      ]
  object DescribeDBClusterParameters
      extends Stream[
        DescribeDbClusterParametersRequest,
        AwsError,
        zio.aws.docdb.model.Parameter.ReadOnly
      ]
  object DescribeDBClusterParametersPaginated
      extends Effect[
        DescribeDbClusterParametersRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly
      ]
  object ModifyEventSubscription
      extends Effect[
        ModifyEventSubscriptionRequest,
        AwsError,
        zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly
      ]
  object CreateDBInstance
      extends Effect[
        CreateDbInstanceRequest,
        AwsError,
        zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly
      ]
  object DeleteDBClusterSnapshot
      extends Effect[
        DeleteDbClusterSnapshotRequest,
        AwsError,
        zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly
      ]
  object StartDBCluster
      extends Effect[
        StartDbClusterRequest,
        AwsError,
        zio.aws.docdb.model.StartDbClusterResponse.ReadOnly
      ]
  object ModifyDBClusterSnapshotAttribute
      extends Effect[
        ModifyDbClusterSnapshotAttributeRequest,
        AwsError,
        zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
      ]
  object DescribeEventCategories
      extends Effect[
        DescribeEventCategoriesRequest,
        AwsError,
        zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly
      ]
  object DeleteDBSubnetGroup
      extends Effect[DeleteDbSubnetGroupRequest, AwsError, Unit]
  object RebootDBInstance
      extends Effect[
        RebootDbInstanceRequest,
        AwsError,
        zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly
      ]
  object DescribeDBClusterParameterGroups
      extends Stream[
        DescribeDbClusterParameterGroupsRequest,
        AwsError,
        zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
      ]
  object DescribeDBClusterParameterGroupsPaginated
      extends Effect[
        DescribeDbClusterParameterGroupsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
      ]
  object CreateEventSubscription
      extends Effect[CreateEventSubscriptionRequest, AwsError, ReadOnly]
  object ListTagsForResource
      extends Effect[
        ListTagsForResourceRequest,
        AwsError,
        zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly
      ]
  object RestoreDBClusterToPointInTime
      extends Effect[
        RestoreDbClusterToPointInTimeRequest,
        AwsError,
        zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
      ]
  object DescribeDBClusters
      extends Stream[
        DescribeDbClustersRequest,
        AwsError,
        zio.aws.docdb.model.DBCluster.ReadOnly
      ]
  object DescribeDBClustersPaginated
      extends Effect[
        DescribeDbClustersRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbClustersResponse.ReadOnly
      ]
  object FailoverDBCluster
      extends Effect[
        FailoverDbClusterRequest,
        AwsError,
        zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly
      ]
  object DescribeEventSubscriptions
      extends Stream[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.docdb.model.EventSubscription.ReadOnly
      ]
  object DescribeEventSubscriptionsPaginated
      extends Effect[
        DescribeEventSubscriptionsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeEventSubscriptionsResponse.ReadOnly
      ]
  object DescribeDBInstances
      extends Stream[
        DescribeDbInstancesRequest,
        AwsError,
        zio.aws.docdb.model.DBInstance.ReadOnly
      ]
  object DescribeDBInstancesPaginated
      extends Effect[
        DescribeDbInstancesRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly
      ]
  object CreateDBClusterSnapshot
      extends Effect[
        CreateDbClusterSnapshotRequest,
        AwsError,
        zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly
      ]
  object DeleteDBCluster
      extends Effect[
        DeleteDbClusterRequest,
        AwsError,
        zio.aws.docdb.model.DeleteDbClusterResponse.ReadOnly
      ]
  object DeleteGlobalCluster
      extends Effect[
        DeleteGlobalClusterRequest,
        AwsError,
        zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly
      ]
  object DeleteDBInstance
      extends Effect[
        DeleteDbInstanceRequest,
        AwsError,
        zio.aws.docdb.model.DeleteDbInstanceResponse.ReadOnly
      ]
  object AddSourceIdentifierToSubscription
      extends Effect[
        AddSourceIdentifierToSubscriptionRequest,
        AwsError,
        zio.aws.docdb.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
      ]
  object DescribeDBEngineVersions
      extends Stream[
        DescribeDbEngineVersionsRequest,
        AwsError,
        zio.aws.docdb.model.DBEngineVersion.ReadOnly
      ]
  object DescribeDBEngineVersionsPaginated
      extends Effect[
        DescribeDbEngineVersionsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly
      ]
  object CreateGlobalCluster
      extends Effect[
        CreateGlobalClusterRequest,
        AwsError,
        zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly
      ]
  object DescribeOrderableDBInstanceOptions
      extends Stream[
        DescribeOrderableDbInstanceOptionsRequest,
        AwsError,
        zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly
      ]
  object DescribeOrderableDBInstanceOptionsPaginated
      extends Effect[
        DescribeOrderableDbInstanceOptionsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
      ]
  object DescribeDBClusterSnapshotAttributes
      extends Effect[
        DescribeDbClusterSnapshotAttributesRequest,
        AwsError,
        zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
      ]
  object DescribeEvents
      extends Stream[
        DescribeEventsRequest,
        AwsError,
        zio.aws.docdb.model.Event.ReadOnly
      ]
  object DescribeEventsPaginated
      extends Effect[
        DescribeEventsRequest,
        AwsError,
        zio.aws.docdb.model.DescribeEventsResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, DocDb] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, DocDb] { rts =>
        zio.ZIO.succeed {
          new DocDb {
            val api: DocDbAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): DocDb = this
            def copyDBClusterSnapshot(
                request: CopyDbClusterSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.CopyDbClusterSnapshotResponse.ReadOnly
            ] = proxy(CopyDBClusterSnapshot, request)
            def modifyDBInstance(request: ModifyDbInstanceRequest): IO[
              AwsError,
              zio.aws.docdb.model.ModifyDbInstanceResponse.ReadOnly
            ] = proxy(ModifyDBInstance, request)
            def addTagsToResource(
                request: AddTagsToResourceRequest
            ): IO[AwsError, Unit] = proxy(AddTagsToResource, request)
            def describeDBClusterSnapshots(
                request: DescribeDbClusterSnapshotsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.DBClusterSnapshot.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusterSnapshots, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClusterSnapshotsPaginated(
                request: DescribeDbClusterSnapshotsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbClusterSnapshotsResponse.ReadOnly
            ] = proxy(DescribeDBClusterSnapshotsPaginated, request)
            def resetDBClusterParameterGroup(
                request: ResetDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.ResetDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(ResetDBClusterParameterGroup, request)
            def removeSourceIdentifierFromSubscription(
                request: RemoveSourceIdentifierFromSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.RemoveSourceIdentifierFromSubscriptionResponse.ReadOnly
            ] = proxy(RemoveSourceIdentifierFromSubscription, request)
            def describeEngineDefaultClusterParameters(
                request: DescribeEngineDefaultClusterParametersRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeEngineDefaultClusterParametersResponse.ReadOnly
            ] = proxy(DescribeEngineDefaultClusterParameters, request)
            def createDBSubnetGroup(request: CreateDbSubnetGroupRequest): IO[
              AwsError,
              zio.aws.docdb.model.CreateDbSubnetGroupResponse.ReadOnly
            ] = proxy(CreateDBSubnetGroup, request)
            def copyDBClusterParameterGroup(
                request: CopyDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.CopyDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(CopyDBClusterParameterGroup, request)
            def describePendingMaintenanceActions(
                request: DescribePendingMaintenanceActionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.ResourcePendingMaintenanceActions.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribePendingMaintenanceActions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describePendingMaintenanceActionsPaginated(
                request: DescribePendingMaintenanceActionsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribePendingMaintenanceActionsResponse.ReadOnly
            ] = proxy(DescribePendingMaintenanceActionsPaginated, request)
            def deleteDBClusterParameterGroup(
                request: DeleteDbClusterParameterGroupRequest
            ): IO[AwsError, Unit] =
              proxy(DeleteDBClusterParameterGroup, request)
            def removeFromGlobalCluster(
                request: RemoveFromGlobalClusterRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.RemoveFromGlobalClusterResponse.ReadOnly
            ] = proxy(RemoveFromGlobalCluster, request)
            def modifyDBClusterParameterGroup(
                request: ModifyDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.ModifyDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(ModifyDBClusterParameterGroup, request)
            def stopDBCluster(request: StopDbClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.StopDbClusterResponse.ReadOnly
            ] = proxy(StopDBCluster, request)
            def createDBCluster(request: CreateDbClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.CreateDbClusterResponse.ReadOnly
            ] = proxy(CreateDBCluster, request)
            def describeCertificates(
                request: DescribeCertificatesRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.Certificate.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeCertificates, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeCertificatesPaginated(
                request: DescribeCertificatesRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeCertificatesResponse.ReadOnly
            ] = proxy(DescribeCertificatesPaginated, request)
            def deleteEventSubscription(
                request: DeleteEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DeleteEventSubscriptionResponse.ReadOnly
            ] = proxy(DeleteEventSubscription, request)
            def describeDBSubnetGroups(
                request: DescribeDbSubnetGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.DBSubnetGroup.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBSubnetGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBSubnetGroupsPaginated(
                request: DescribeDbSubnetGroupsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbSubnetGroupsResponse.ReadOnly
            ] = proxy(DescribeDBSubnetGroupsPaginated, request)
            def createDBClusterParameterGroup(
                request: CreateDbClusterParameterGroupRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.CreateDbClusterParameterGroupResponse.ReadOnly
            ] = proxy(CreateDBClusterParameterGroup, request)
            def modifyDBCluster(request: ModifyDbClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.ModifyDbClusterResponse.ReadOnly
            ] = proxy(ModifyDBCluster, request)
            def removeTagsFromResource(
                request: RemoveTagsFromResourceRequest
            ): IO[AwsError, Unit] = proxy(RemoveTagsFromResource, request)
            def applyPendingMaintenanceAction(
                request: ApplyPendingMaintenanceActionRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.ApplyPendingMaintenanceActionResponse.ReadOnly
            ] = proxy(ApplyPendingMaintenanceAction, request)
            def modifyDBSubnetGroup(request: ModifyDbSubnetGroupRequest): IO[
              AwsError,
              zio.aws.docdb.model.ModifyDbSubnetGroupResponse.ReadOnly
            ] = proxy(ModifyDBSubnetGroup, request)
            def modifyGlobalCluster(request: ModifyGlobalClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.ModifyGlobalClusterResponse.ReadOnly
            ] = proxy(ModifyGlobalCluster, request)
            def restoreDBClusterFromSnapshot(
                request: RestoreDbClusterFromSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.RestoreDbClusterFromSnapshotResponse.ReadOnly
            ] = proxy(RestoreDBClusterFromSnapshot, request)
            def describeGlobalClusters(
                request: DescribeGlobalClustersRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.GlobalCluster.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeGlobalClusters, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeGlobalClustersPaginated(
                request: DescribeGlobalClustersRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeGlobalClustersResponse.ReadOnly
            ] = proxy(DescribeGlobalClustersPaginated, request)
            def describeDBClusterParameters(
                request: DescribeDbClusterParametersRequest
            ): ZStream[Any, AwsError, zio.aws.docdb.model.Parameter.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeDBClusterParameters, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeDBClusterParametersPaginated(
                request: DescribeDbClusterParametersRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbClusterParametersResponse.ReadOnly
            ] = proxy(DescribeDBClusterParametersPaginated, request)
            def modifyEventSubscription(
                request: ModifyEventSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.ModifyEventSubscriptionResponse.ReadOnly
            ] = proxy(ModifyEventSubscription, request)
            def createDBInstance(request: CreateDbInstanceRequest): IO[
              AwsError,
              zio.aws.docdb.model.CreateDbInstanceResponse.ReadOnly
            ] = proxy(CreateDBInstance, request)
            def deleteDBClusterSnapshot(
                request: DeleteDbClusterSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DeleteDbClusterSnapshotResponse.ReadOnly
            ] = proxy(DeleteDBClusterSnapshot, request)
            def startDBCluster(request: StartDbClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.StartDbClusterResponse.ReadOnly
            ] = proxy(StartDBCluster, request)
            def modifyDBClusterSnapshotAttribute(
                request: ModifyDbClusterSnapshotAttributeRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.ModifyDbClusterSnapshotAttributeResponse.ReadOnly
            ] = proxy(ModifyDBClusterSnapshotAttribute, request)
            def describeEventCategories(
                request: DescribeEventCategoriesRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeEventCategoriesResponse.ReadOnly
            ] = proxy(DescribeEventCategories, request)
            def deleteDBSubnetGroup(
                request: DeleteDbSubnetGroupRequest
            ): IO[AwsError, Unit] = proxy(DeleteDBSubnetGroup, request)
            def rebootDBInstance(request: RebootDbInstanceRequest): IO[
              AwsError,
              zio.aws.docdb.model.RebootDbInstanceResponse.ReadOnly
            ] = proxy(RebootDBInstance, request)
            def describeDBClusterParameterGroups(
                request: DescribeDbClusterParameterGroupsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.DBClusterParameterGroup.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBClusterParameterGroups, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBClusterParameterGroupsPaginated(
                request: DescribeDbClusterParameterGroupsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbClusterParameterGroupsResponse.ReadOnly
            ] = proxy(DescribeDBClusterParameterGroupsPaginated, request)
            def createEventSubscription(
                request: CreateEventSubscriptionRequest
            ): IO[AwsError, ReadOnly] = proxy(CreateEventSubscription, request)
            def listTagsForResource(request: ListTagsForResourceRequest): IO[
              AwsError,
              zio.aws.docdb.model.ListTagsForResourceResponse.ReadOnly
            ] = proxy(ListTagsForResource, request)
            def restoreDBClusterToPointInTime(
                request: RestoreDbClusterToPointInTimeRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.RestoreDbClusterToPointInTimeResponse.ReadOnly
            ] = proxy(RestoreDBClusterToPointInTime, request)
            def describeDBClusters(
                request: DescribeDbClustersRequest
            ): ZStream[Any, AwsError, zio.aws.docdb.model.DBCluster.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeDBClusters, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeDBClustersPaginated(
                request: DescribeDbClustersRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbClustersResponse.ReadOnly
            ] = proxy(DescribeDBClustersPaginated, request)
            def failoverDBCluster(request: FailoverDbClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.FailoverDbClusterResponse.ReadOnly
            ] = proxy(FailoverDBCluster, request)
            def describeEventSubscriptions(
                request: DescribeEventSubscriptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.EventSubscription.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeEventSubscriptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeEventSubscriptionsPaginated(
                request: DescribeEventSubscriptionsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeEventSubscriptionsResponse.ReadOnly
            ] = proxy(DescribeEventSubscriptionsPaginated, request)
            def describeDBInstances(
                request: DescribeDbInstancesRequest
            ): ZStream[Any, AwsError, zio.aws.docdb.model.DBInstance.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeDBInstances, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeDBInstancesPaginated(
                request: DescribeDbInstancesRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbInstancesResponse.ReadOnly
            ] = proxy(DescribeDBInstancesPaginated, request)
            def createDBClusterSnapshot(
                request: CreateDbClusterSnapshotRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.CreateDbClusterSnapshotResponse.ReadOnly
            ] = proxy(CreateDBClusterSnapshot, request)
            def deleteDBCluster(request: DeleteDbClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.DeleteDbClusterResponse.ReadOnly
            ] = proxy(DeleteDBCluster, request)
            def deleteGlobalCluster(request: DeleteGlobalClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.DeleteGlobalClusterResponse.ReadOnly
            ] = proxy(DeleteGlobalCluster, request)
            def deleteDBInstance(request: DeleteDbInstanceRequest): IO[
              AwsError,
              zio.aws.docdb.model.DeleteDbInstanceResponse.ReadOnly
            ] = proxy(DeleteDBInstance, request)
            def addSourceIdentifierToSubscription(
                request: AddSourceIdentifierToSubscriptionRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.AddSourceIdentifierToSubscriptionResponse.ReadOnly
            ] = proxy(AddSourceIdentifierToSubscription, request)
            def describeDBEngineVersions(
                request: DescribeDbEngineVersionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.DBEngineVersion.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeDBEngineVersions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeDBEngineVersionsPaginated(
                request: DescribeDbEngineVersionsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbEngineVersionsResponse.ReadOnly
            ] = proxy(DescribeDBEngineVersionsPaginated, request)
            def createGlobalCluster(request: CreateGlobalClusterRequest): IO[
              AwsError,
              zio.aws.docdb.model.CreateGlobalClusterResponse.ReadOnly
            ] = proxy(CreateGlobalCluster, request)
            def describeOrderableDBInstanceOptions(
                request: DescribeOrderableDbInstanceOptionsRequest
            ): ZStream[
              Any,
              AwsError,
              zio.aws.docdb.model.OrderableDBInstanceOption.ReadOnly
            ] = zio.Unsafe.unsafeCompat { implicit u =>
              rts.unsafe
                .run {
                  proxy(DescribeOrderableDBInstanceOptions, request)
                }
                .getOrThrowFiberFailure()
            }
            def describeOrderableDBInstanceOptionsPaginated(
                request: DescribeOrderableDbInstanceOptionsRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeOrderableDbInstanceOptionsResponse.ReadOnly
            ] = proxy(DescribeOrderableDBInstanceOptionsPaginated, request)
            def describeDBClusterSnapshotAttributes(
                request: DescribeDbClusterSnapshotAttributesRequest
            ): IO[
              AwsError,
              zio.aws.docdb.model.DescribeDbClusterSnapshotAttributesResponse.ReadOnly
            ] = proxy(DescribeDBClusterSnapshotAttributes, request)
            def describeEvents(
                request: DescribeEventsRequest
            ): ZStream[Any, AwsError, zio.aws.docdb.model.Event.ReadOnly] =
              zio.Unsafe.unsafeCompat { implicit u =>
                rts.unsafe
                  .run {
                    proxy(DescribeEvents, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def describeEventsPaginated(request: DescribeEventsRequest): IO[
              AwsError,
              zio.aws.docdb.model.DescribeEventsResponse.ReadOnly
            ] = proxy(DescribeEventsPaginated, request)
          }
        }
      }
    }
  }
}
