package zio.aws.docdb.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class AddSourceIdentifierToSubscriptionRequest(
    subscriptionName: String,
    sourceIdentifier: String
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest = {
    import AddSourceIdentifierToSubscriptionRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest
      .builder()
      .subscriptionName(subscriptionName: java.lang.String)
      .sourceIdentifier(sourceIdentifier: java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.docdb.model.AddSourceIdentifierToSubscriptionRequest.ReadOnly =
    zio.aws.docdb.model.AddSourceIdentifierToSubscriptionRequest
      .wrap(buildAwsValue())
}
object AddSourceIdentifierToSubscriptionRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.docdb.model.AddSourceIdentifierToSubscriptionRequest =
      zio.aws.docdb.model.AddSourceIdentifierToSubscriptionRequest(
        subscriptionName,
        sourceIdentifier
      )
    def subscriptionName: String
    def sourceIdentifier: String
    def getSubscriptionName: ZIO[Any, Nothing, String] =
      ZIO.succeed(subscriptionName)
    def getSourceIdentifier: ZIO[Any, Nothing, String] =
      ZIO.succeed(sourceIdentifier)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest
  ) extends zio.aws.docdb.model.AddSourceIdentifierToSubscriptionRequest.ReadOnly {
    override val subscriptionName: String = impl.subscriptionName(): String
    override val sourceIdentifier: String = impl.sourceIdentifier(): String
  }
  def wrap(
      impl: software.amazon.awssdk.services.docdb.model.AddSourceIdentifierToSubscriptionRequest
  ): zio.aws.docdb.model.AddSourceIdentifierToSubscriptionRequest.ReadOnly =
    new Wrapper(impl)
}
